/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IDynamics;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IParticleI;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IString
extends IDynamicsBase {
    public IParticleI pt1;
    public IParticleI pt2;
    public IVec frc = new IVec();
    public double len;
    public double maxTension = -1.0;

    public IString(IParticleI iParticleI, IParticleI iParticleI2, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.len = this.pt1.pos().dist(this.pt2.pos());
    }

    public IString(IParticleI iParticleI, IParticleI iParticleI2, double d, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.len = d;
    }

    public IString(IVecI iVecI, IVecI iVecI2, IObject iObject) {
        this((IParticleI)new IParticleGeo(iVecI.get()), (IParticleI)new IParticleGeo(iVecI2.get()), iObject);
    }

    public IString(IVecI iVecI, IVecI iVecI2, double d, IObject iObject) {
        this(new IParticleGeo(iVecI.get()), new IParticleGeo(iVecI2.get()), d, iObject);
    }

    public IString(IParticleI iParticleI, IParticleI iParticleI2) {
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.len = this.pt1.pos().dist(this.pt2.pos());
    }

    public IString(IParticleI iParticleI, IParticleI iParticleI2, double d) {
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.len = d;
    }

    public IString(IVecI iVecI, IVecI iVecI2) {
        this(new IParticleGeo(iVecI.get()), new IParticleGeo(iVecI2.get()));
    }

    public IString(IVecI iVecI, IVecI iVecI2, double d) {
        this((IParticleI)new IParticleGeo(iVecI.get()), (IParticleI)new IParticleGeo(iVecI2.get()), d);
    }

    public double len() {
        return this.len;
    }

    IString len(double d) {
        this.len = d;
        return this;
    }

    public IParticleI pt(int n) {
        if (n == 1) {
            return this.pt2;
        }
        return this.pt1;
    }

    public IParticleI particle(int n) {
        return this.pt(n);
    }

    public IVec pos(int n) {
        return this.pt(n).pos();
    }

    public IParticleI pt1() {
        return this.pt1;
    }

    public IParticleI particle1() {
        return this.pt1();
    }

    public IVec pos1() {
        return this.pt1().pos();
    }

    public IParticleI pt2() {
        return this.pt2;
    }

    public IParticleI particle2() {
        return this.pt2();
    }

    public IVec pos2() {
        return this.pt2().pos();
    }

    @Override
    public IString parent(IObject iObject) {
        super.parent(iObject);
        return this;
    }

    @Override
    public IString target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    @Override
    public IString removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    @Override
    public IString removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }

    @Override
    public synchronized void preupdate() {
        if (this.len < IConfig.tolerance) {
            this.frc = this.pt2.frc().dif(this.pt1.frc());
        } else {
            IVec iVec = this.pt2.pos().dif(this.pt1.pos());
            double d = iVec.len();
            iVec.div(d);
            double d2 = 0.0;
            double d3 = 0.0;
            if (!this.pt1.fixed()) {
                d2 = this.pt1.frc().dot(iVec);
            }
            if (!this.pt2.fixed()) {
                d3 = this.pt2.frc().dot(iVec);
            }
            if (d2 > 0.0) {
                d2 = 0.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            this.frc = iVec.mul(d3 - d2);
        }
    }

    @Override
    public synchronized void postinteract(ArrayList<IDynamics> arrayList) {
        if (!this.pt1.fixed()) {
            this.pt1.push(this.frc);
        }
        if (!this.pt2.fixed()) {
            this.pt2.pull(this.frc);
        }
        IVec iVec = this.pt2.pos().dif(this.pt1.pos());
        double d = iVec.len();
        if (this.len < IConfig.tolerance) {
            IVec iVec2 = this.pt1.vel().mid(this.pt2.vel());
            if (!this.pt1.fixed()) {
                this.pt1.vel(iVec2);
            }
            if (!this.pt2.fixed()) {
                this.pt2.vel(iVec2);
            }
        } else if (!this.pt1.fixed() || !this.pt2.fixed()) {
            iVec.div(d);
            IVec iVec3 = this.pt1.vel().cp();
            IVec iVec4 = this.pt2.vel().cp();
            double d2 = iVec.dot(iVec3);
            double d3 = iVec.dot(iVec4);
            if (d2 - d3 > 0.0) {
                IVec iVec5 = iVec.cp().mul(d2);
                iVec3.sub(iVec5);
                IVec iVec6 = iVec.cp().mul(d3);
                iVec4.sub(iVec6);
                if (this.pt1.fixed()) {
                    this.pt2.vel(iVec4);
                } else if (this.pt2.fixed()) {
                    this.pt1.vel(iVec3);
                } else {
                    iVec5.add(iVec6).div(2.0);
                    this.pt1.vel(iVec3.add(iVec5));
                    this.pt2.vel(iVec4.add(iVec5));
                }
            }
        }
    }

    @Override
    public synchronized void postupdate() {
        IVec iVec = this.pt2.pos().dif(this.pt1.pos());
        double d = iVec.len();
        if (d > this.len) {
            if (!this.pt1.fixed() && !this.pt2.fixed()) {
                IVec iVec2 = this.pt1.pos().mid(this.pt2.pos());
                iVec.len(this.len);
                this.pt1.set(iVec2.add(iVec, -0.5));
                this.pt2.set(iVec2.add(iVec));
                iVec.unit();
                double d2 = this.pt1.vel().dot(iVec);
                double d3 = this.pt2.vel().dot(iVec);
                if (d2 < 0.0) {
                    this.pt1.vel().add(iVec, -d2);
                }
                if (d3 > 0.0) {
                    this.pt2.vel().add(iVec, -d3);
                }
            } else if (!this.pt2.fixed()) {
                iVec.len(this.len);
                this.pt2.set(iVec.add(this.pt1.pos()));
                iVec.unit();
                double d4 = this.pt2.vel().dot(iVec);
                if (d4 > 0.0) {
                    this.pt2.vel().add(iVec, -d4);
                }
            } else if (!this.pt1.fixed()) {
                iVec.len(this.len);
                this.pt1.set(iVec.neg().add(this.pt2.pos()));
                iVec.unit();
                double d5 = this.pt1.vel().dot(iVec);
                if (d5 < 0.0) {
                    this.pt1.vel().add(iVec, -d5);
                }
            }
        }
    }
}

