/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAgent;
import igeo.IConfig;
import igeo.IDynamics;
import igeo.ILayer;
import igeo.IParticleI;
import igeo.ITrajectoryI;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IWall
extends IAgent {
    public ArrayList<Class<? extends IParticleI>> targetClasses;
    public IVecI planeDir;
    public IVecI planePt;
    public IVec planeDirCache;
    public double elasticity = 1.0;
    public double friction = 0.0;
    public boolean forceToMoveToFront = false;

    public IWall targetClass(Class<? extends IParticleI> clazz) {
        this.targetClasses = new ArrayList();
        this.targetClasses.add(clazz);
        return this;
    }

    public IWall targetClass(Class<? extends IParticleI> ... classArray) {
        this.targetClasses = new ArrayList();
        for (Class<? extends IParticleI> clazz : classArray) {
            this.targetClasses.add(clazz);
        }
        return this;
    }

    public boolean isTargetClass(Object object) {
        for (int i = 0; i < this.targetClasses.size(); ++i) {
            if (!this.targetClasses.get(i).isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public IWall(IVecI iVecI, IVecI iVecI2) {
        this.planeDir = iVecI;
        this.planePt = iVecI2;
    }

    public IWall(IWall iWall) {
        this.planeDir = iWall.planeDir;
        this.planePt = iWall.planePt;
        this.elasticity = iWall.elasticity;
        this.friction = iWall.friction;
        if (iWall.targetClasses != null) {
            this.targetClasses = new ArrayList();
            for (int i = 0; i < iWall.targetClasses.size(); ++i) {
                this.targetClasses.add(iWall.targetClasses.get(i));
            }
        }
    }

    public IWall fric(double d) {
        this.friction = d;
        return this;
    }

    public double fric() {
        return this.friction;
    }

    public IWall friction(double d) {
        return this.fric(d);
    }

    public double friction() {
        return this.fric();
    }

    public IWall elast(double d) {
        this.elasticity = d;
        return this;
    }

    public double elast() {
        return this.elasticity;
    }

    public IWall elasticity(double d) {
        return this.elast(d);
    }

    public double elasticity() {
        return this.elast();
    }

    public IWall forceToMoveToFront(boolean bl) {
        this.forceToMoveToFront = bl;
        return this;
    }

    public double distToCrossing(IParticleI iParticleI) {
        IVec iVec = IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iParticleI.vel(), iParticleI.pos());
        return iVec.dist(iParticleI.pos());
    }

    public IVec intersect(IVec iVec, IVec iVec2) {
        return IVec.intersectPlaneAndLine(this.planeDir.get(), this.planePt.get(), iVec2.dif(iVec), iVec);
    }

    public boolean isCrossing(IParticleI iParticleI) {
        double d = iParticleI.vel().len2();
        if (d == 0.0) {
            return false;
        }
        IVec iVec = iParticleI.pos().dup();
        IVec iVec2 = iVec.dup().add(iParticleI.vel(), IConfig.updateRate);
        return this.isCrossing(iVec, iVec2);
    }

    public boolean isCrossing(IVec iVec, IVec iVec2) {
        IVec iVec3 = iVec.dif(this.planePt);
        IVec iVec4 = iVec2.dif(this.planePt);
        double d = iVec3.dot(this.planeDir);
        double d2 = iVec4.dot(this.planeDir);
        return d == 0.0 || d * d2 < 0.0;
    }

    @Override
    public void postinteract(ArrayList<IDynamics> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((this.targetClasses != null || !(arrayList.get(i) instanceof IParticleI)) && (this.targetClasses == null || !this.isTargetClass(arrayList.get(i)))) continue;
            this.bounce((IParticleI)((Object)arrayList.get(i)), arrayList);
        }
        if (this.planeDirCache != null) {
            this.planeDirCache = null;
        }
    }

    public IVec closerIntersection(IVec iVec, IVec iVec2, ArrayList<IDynamics> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IWall iWall;
            if (!(arrayList.get(i) instanceof IWall) || arrayList.get(i) == this || !(iWall = (IWall)arrayList.get(i)).isCrossing(iVec, iVec2)) continue;
            iVec2 = iWall.intersect(iVec, iVec2);
        }
        return iVec2;
    }

    public void bounce(IParticleI iParticleI, ArrayList<IDynamics> arrayList) {
        double d;
        IVec iVec;
        if (this.forceToMoveToFront && (iVec = iParticleI.pos().dup()).dif(this.planePt).dot(this.planeDir) < 0.0) {
            iVec.projectToPlane(this.planeDir, this.planeDir, this.planePt);
            iParticleI.pos(iVec);
        }
        if ((d = iParticleI.vel().len2()) > 0.0) {
            IVec iVec2 = iParticleI.pos().dup();
            IVec iVec3 = iVec2.dup().add(iParticleI.vel(), IConfig.updateRate);
            iVec2.sub(this.planePt);
            iVec3.sub(this.planePt);
            double d2 = iVec2.dot(this.planeDir);
            double d3 = iVec3.dot(this.planeDir);
            if (d2 == 0.0 || d2 * d3 < 0.0) {
                if (IConfig.checkAdjacentWalls) {
                    double d4 = this.distToCrossing(iParticleI);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!(arrayList.get(i) instanceof IWall) || arrayList.get(i) == this || !(((IWall)arrayList.get(i)).distToCrossing(iParticleI) < d4)) continue;
                        return;
                    }
                }
                if (this.elasticity == 1.0 && this.friction == 0.0) {
                    iParticleI.vel().ref(this.planeDir);
                    if (IConfig.checkAdjacentWalls) {
                        IVec iVec4 = IVec.intersectPlaneAndLine(this.planeDir.get(), iVec3.dif(iVec2), iVec2).add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec4);
                        }
                        IVec iVec5 = iVec3.ref(this.planeDir).add(this.planePt);
                        iVec5 = this.closerIntersection(iVec4, iVec5, arrayList);
                        iParticleI.pos(iVec5);
                        iParticleI.skipUpdateOnce(true);
                    } else {
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            IVec iVec6 = IVec.intersectPlaneAndLine(this.planeDir.get(), iVec3.dif(iVec2), iVec2).add(this.planePt);
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec6);
                        }
                        iParticleI.pos(iVec3.ref(this.planeDir).add(this.planePt));
                        iParticleI.skipUpdateOnce(true);
                    }
                } else {
                    if (this.planeDirCache == null) {
                        this.planeDirCache = this.planeDir.get().dup().unit();
                    }
                    IVec iVec7 = IVec.intersectPlaneAndLine(this.planeDirCache, iVec3.dif(iVec2), iVec2);
                    double d5 = Math.sqrt(iVec3.dist2(iVec7) / iVec3.dist2(iVec2));
                    IVec iVec8 = this.planeDirCache.dup().mul(-this.planeDirCache.dot(iParticleI.vel()));
                    IVec iVec9 = iParticleI.vel().dup().add(iVec8);
                    iVec8.mul(this.elasticity);
                    if (iVec8.len2() == 0.0) {
                        iVec8.set(this.planeDirCache).mul(IConfig.tolerance / IConfig.updateRate);
                        if (this.planeDirCache.dot(iParticleI.vel()) > 0.0) {
                            iVec8.neg();
                        }
                    }
                    iVec9.mul(1.0 - this.friction);
                    if (IConfig.checkAdjacentWalls) {
                        iVec8.add(iVec9);
                        iParticleI.vel(iVec8);
                        iVec7.add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec7);
                        }
                        IVec iVec10 = iVec7.dup().add(iVec8, IConfig.updateRate * d5);
                        iVec10 = this.closerIntersection(iVec7, iVec10, arrayList);
                        iParticleI.pos(iVec10);
                        iParticleI.skipUpdateOnce(true);
                    } else {
                        iVec7.add(this.planePt);
                        if (IConfig.insertBouncePointInTrajectory && iParticleI instanceof ITrajectoryI) {
                            ((ITrajectoryI)((Object)iParticleI)).addCP(iVec7.dup());
                        }
                        iVec8.add(iVec9);
                        iParticleI.vel(iVec8);
                        iParticleI.pos(iVec7.add(iVec8, IConfig.updateRate * d5));
                        iParticleI.skipUpdateOnce(true);
                    }
                }
            }
        }
    }

    @Override
    public IWall name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IWall layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IWall hide() {
        super.hide();
        return this;
    }

    @Override
    public IWall show() {
        super.show();
        return this;
    }
}

