/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;

public class IDoubleBuffer {
    Component component;
    Image screen;
    Graphics graphics;

    IDoubleBuffer(Component component) {
        this.component = component;
    }

    public void initScreen(int n, int n2) {
        this.screen = this.component.createImage(n, n2);
        this.graphics = this.screen.getGraphics();
        if (this.graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
    }

    public Graphics getGraphics() {
        if (this.screen == null) {
            this.initScreen(this.component.getWidth(), this.component.getHeight());
        }
        return this.graphics;
    }

    public void setSize(int n, int n2) {
        this.initScreen(n, n2);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.screen, 0, 0, this.component);
    }
}

