/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IComparator;
import igeo.IDelaunay2D;
import igeo.IOut;
import igeo.ISort;
import igeo.IVec2;
import igeo.gui.IPolyline2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISubsurfaceMesh {
    public static double subsurfaceResolution = 1.0E-15;
    public int uindex;
    public int vindex;
    public double u1;
    public double u2;
    public double v1;
    public double v2;
    public boolean outerTrimAdded = false;
    public ArrayList<IVec2[]> trimCurves = null;
    public ArrayList<IVec2[]> trimLoops = null;

    public ISubsurfaceMesh(int n, int n2, double d, double d2, double d3, double d4) {
        this.uindex = n;
        this.vindex = n2;
        this.u1 = d;
        this.u2 = d2;
        this.v1 = d3;
        this.v2 = d4;
    }

    public ISubsurfaceMesh(int n, int n2, double[] dArray, double[] dArray2) {
        this.uindex = n;
        this.vindex = n2;
        this.u1 = dArray[n];
        this.u2 = dArray[n + 1];
        this.v1 = dArray2[n2];
        this.v2 = dArray2[n2 + 1];
    }

    public ISubsurfaceMesh(int n, int n2) {
        this.uindex = n;
        this.vindex = n2;
    }

    public void addTrimCurve(IVec2[] iVec2Array) {
        if (this.trimCurves == null) {
            this.trimCurves = new ArrayList();
        }
        this.trimCurves.add(iVec2Array);
    }

    public void addTrimLoop(IVec2[] iVec2Array, boolean bl) {
        if (bl) {
            this.outerTrimAdded = true;
        }
        if (this.trimLoops == null) {
            this.trimLoops = new ArrayList();
        }
        this.trimLoops.add(iVec2Array);
    }

    public boolean isPointsOnlyTouchingEdge(ArrayList<IVec2> arrayList) {
        int n;
        int n2;
        int n3;
        IVec2 iVec2 = arrayList.get(1);
        if (iVec2.x > this.u1 && iVec2.x < this.u2 && iVec2.y > this.v1 && iVec2.y < this.v2) {
            return false;
        }
        boolean bl = true;
        for (n3 = 1; n3 < arrayList.size() - 1 && bl; ++n3) {
            if (!(arrayList.get((int)n3).x > this.u1)) continue;
            bl = false;
        }
        if (bl) {
            return arrayList.get((int)0).x <= this.u1 && arrayList.get((int)(arrayList.size() - 1)).x <= this.u1;
        }
        n3 = 1;
        for (n2 = 1; n2 < arrayList.size() - 1 && n3 != 0; ++n2) {
            if (!(arrayList.get((int)n2).x < this.u2)) continue;
            n3 = 0;
        }
        if (n3 != 0) {
            return arrayList.get((int)0).x >= this.u2 && arrayList.get((int)(arrayList.size() - 1)).x >= this.u2;
        }
        n2 = 1;
        for (n = 1; n < arrayList.size() - 1 && n2 != 0; ++n) {
            if (!(arrayList.get((int)n).y > this.v1)) continue;
            n2 = 0;
        }
        if (n2 != 0) {
            return arrayList.get((int)0).y <= this.v1 && arrayList.get((int)(arrayList.size() - 1)).y <= this.v1;
        }
        n = 1;
        for (int i = 1; i < arrayList.size() - 1 && n != 0; ++i) {
            if (!(arrayList.get((int)i).y < this.v2)) continue;
            n = 0;
        }
        if (n != 0) {
            return arrayList.get((int)0).y >= this.v2 && arrayList.get((int)(arrayList.size() - 1)).y >= this.v2;
        }
        return false;
    }

    public void addTrimPolyline(ArrayList<IVec2> arrayList) {
        if (arrayList.size() < 3) {
            IOut.err("polyline's point number is too small (" + arrayList.size() + ")");
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i <= 0 || i >= arrayList.size() - 1 || !(arrayList.get((int)i).x < this.u1 || arrayList.get((int)i).x > this.u2 || arrayList.get((int)i).y < this.v1) && !(arrayList.get((int)i).y > this.v2)) continue;
            IOut.err("point is out of area");
        }
        if (this.isPointsOnlyTouchingEdge(arrayList)) {
            return;
        }
        IVec2 iVec2 = this.intersectWithEdge(arrayList.get(1), arrayList.get(0));
        IVec2 iVec22 = this.intersectWithEdge(arrayList.get(arrayList.size() - 2), arrayList.get(arrayList.size() - 1));
        if (iVec2 == null) {
            IOut.err("no start point found");
            return;
        }
        if (iVec22 == null) {
            IOut.err("no end point found");
            return;
        }
        if (iVec2.x == arrayList.get((int)1).x && iVec2.y == arrayList.get((int)1).y) {
            arrayList.remove(1);
        }
        if (iVec22.x == arrayList.get((int)(arrayList.size() - 2)).x && iVec22.y == arrayList.get((int)(arrayList.size() - 2)).y) {
            arrayList.remove(arrayList.size() - 2);
        }
        int n = 0;
        for (int i = 1; i < arrayList.size() - 1; ++i) {
            if (!(arrayList.get((int)i).x <= this.u1 || arrayList.get((int)i).x >= this.u2 || arrayList.get((int)i).y <= this.v1) && !(arrayList.get((int)i).y >= this.v2)) continue;
            IVec2[] iVec2Array = new IVec2[i - n + 1];
            for (int j = n; j <= i; ++j) {
                iVec2Array[j - n] = j == 0 ? iVec2 : arrayList.get(j);
            }
            this.addTrimCurve(iVec2Array);
            n = i;
        }
        if (n != 0) {
            IVec2[] iVec2Array = new IVec2[arrayList.size() - n];
            for (int i = n; i < arrayList.size(); ++i) {
                iVec2Array[i - n] = i == arrayList.size() - 1 ? iVec22 : arrayList.get(i);
            }
            this.addTrimCurve(iVec2Array);
            return;
        }
        IVec2[] iVec2Array = new IVec2[arrayList.size()];
        iVec2Array[0] = iVec2;
        for (int i = 1; i < arrayList.size() - 1; ++i) {
            iVec2Array[i] = arrayList.get(i);
        }
        iVec2Array[arrayList.size() - 1] = iVec22;
        this.addTrimCurve(iVec2Array);
    }

    public void addUTrimLine(IVec2 iVec2, IVec2 iVec22) {
        if (iVec2.y == this.v1 && iVec22.y == this.v1 || iVec2.y == this.v2 && iVec22.y == this.v2) {
            return;
        }
        IVec2[] iVec2Array = new IVec2[2];
        int n = 0;
        int n2 = 1;
        if (iVec2.x > iVec22.x) {
            n = 1;
            n2 = 0;
        }
        iVec2Array[n] = this.intersectOnLeft(iVec2, iVec22);
        iVec2Array[n2] = this.intersectOnRight(iVec2, iVec22);
        this.addTrimCurve(iVec2Array);
    }

    public void addVTrimLine(IVec2 iVec2, IVec2 iVec22) {
        if (iVec2.x == this.u1 && iVec22.x == this.u1 || iVec2.x == this.u2 && iVec22.x == this.u2) {
            return;
        }
        IVec2[] iVec2Array = new IVec2[2];
        int n = 0;
        int n2 = 1;
        if (iVec2.y > iVec22.y) {
            n = 1;
            n2 = 0;
        }
        iVec2Array[n] = this.intersectOnBottom(iVec2, iVec22);
        iVec2Array[n2] = this.intersectOnTop(iVec2, iVec22);
        this.addTrimCurve(iVec2Array);
    }

    public void addTrimLineAtBottomLeft(IVec2 iVec2, IVec2 iVec22) {
        IVec2 iVec23 = this.intersectOnLeft(iVec2, iVec22);
        if (iVec23 == null || iVec23.y <= this.v1) {
            return;
        }
        IVec2 iVec24 = this.intersectOnBottom(iVec2, iVec22);
        if (iVec24 == null || iVec24.x <= this.u1) {
            return;
        }
        IVec2[] iVec2Array = new IVec2[2];
        if (iVec2.x < iVec22.x) {
            iVec2Array[0] = iVec23;
            iVec2Array[1] = iVec24;
        } else {
            iVec2Array[0] = iVec24;
            iVec2Array[1] = iVec23;
        }
        this.addTrimCurve(iVec2Array);
    }

    public void addTrimLineAtBottomRight(IVec2 iVec2, IVec2 iVec22) {
        IVec2 iVec23 = this.intersectOnRight(iVec2, iVec22);
        if (iVec23 == null || iVec23.y <= this.v1) {
            return;
        }
        IVec2 iVec24 = this.intersectOnBottom(iVec2, iVec22);
        if (iVec24 == null || iVec24.x >= this.u2) {
            return;
        }
        IVec2[] iVec2Array = new IVec2[2];
        if (iVec2.x < iVec22.x) {
            iVec2Array[0] = iVec24;
            iVec2Array[1] = iVec23;
        } else {
            iVec2Array[0] = iVec23;
            iVec2Array[1] = iVec24;
        }
        this.addTrimCurve(iVec2Array);
    }

    public void addTrimLineAtTopLeft(IVec2 iVec2, IVec2 iVec22) {
        IVec2 iVec23 = this.intersectOnLeft(iVec2, iVec22);
        if (iVec23 == null || iVec23.y >= this.v2) {
            return;
        }
        IVec2 iVec24 = this.intersectOnTop(iVec2, iVec22);
        if (iVec24 == null || iVec24.x <= this.u1) {
            return;
        }
        IVec2[] iVec2Array = new IVec2[2];
        if (iVec2.x < iVec22.x) {
            iVec2Array[0] = iVec23;
            iVec2Array[1] = iVec24;
        } else {
            iVec2Array[0] = iVec24;
            iVec2Array[1] = iVec23;
        }
        this.addTrimCurve(iVec2Array);
    }

    public void addTrimLineAtTopRight(IVec2 iVec2, IVec2 iVec22) {
        IVec2 iVec23 = this.intersectOnRight(iVec2, iVec22);
        if (iVec23 == null || iVec23.y >= this.v2) {
            return;
        }
        IVec2 iVec24 = this.intersectOnTop(iVec2, iVec22);
        if (iVec24 == null || iVec24.x >= this.u2) {
            return;
        }
        IVec2[] iVec2Array = new IVec2[2];
        if (iVec2.x < iVec22.x) {
            iVec2Array[0] = iVec24;
            iVec2Array[1] = iVec23;
        } else {
            iVec2Array[0] = iVec23;
            iVec2Array[1] = iVec24;
        }
        this.addTrimCurve(iVec2Array);
    }

    public IVec2 intersectOnLeft(IVec2 iVec2, IVec2 iVec22) {
        return IVec2.intersectYLine(iVec2, iVec22.diff(iVec2), this.u1);
    }

    public IVec2 intersectOnRight(IVec2 iVec2, IVec2 iVec22) {
        return IVec2.intersectYLine(iVec2, iVec22.diff(iVec2), this.u2);
    }

    public IVec2 intersectOnBottom(IVec2 iVec2, IVec2 iVec22) {
        return IVec2.intersectXLine(iVec2, iVec22.diff(iVec2), this.v1);
    }

    public IVec2 intersectOnTop(IVec2 iVec2, IVec2 iVec22) {
        return IVec2.intersectXLine(iVec2, iVec22.diff(iVec2), this.v2);
    }

    public boolean isCrossingXLine(IVec2 iVec2, IVec2 iVec22, double d) {
        if (iVec2.y == d && iVec22.y == d) {
            return false;
        }
        return iVec2.y <= d && iVec22.y >= d || iVec2.y >= d && iVec22.y <= d;
    }

    public boolean isCrossingYLine(IVec2 iVec2, IVec2 iVec22, double d) {
        if (iVec2.x == d && iVec22.x == d) {
            return false;
        }
        return iVec2.x <= d && iVec22.x >= d || iVec2.x >= d && iVec22.x <= d;
    }

    public boolean isCrossingLeft(IVec2 iVec2, IVec2 iVec22) {
        return this.isCrossingYLine(iVec2, iVec22, this.u1);
    }

    public boolean isCrossingRight(IVec2 iVec2, IVec2 iVec22) {
        return this.isCrossingYLine(iVec2, iVec22, this.u2);
    }

    public boolean isCrossingBottom(IVec2 iVec2, IVec2 iVec22) {
        return this.isCrossingXLine(iVec2, iVec22, this.v1);
    }

    public boolean isCrossingTop(IVec2 iVec2, IVec2 iVec22) {
        return this.isCrossingXLine(iVec2, iVec22, this.v2);
    }

    public boolean isInside(IVec2 iVec2) {
        return iVec2.x >= this.u1 && iVec2.x <= this.u2 && iVec2.y >= this.v1 && iVec2.y <= this.v2;
    }

    protected boolean isPointOnAnyEdge(IVec2 iVec2) {
        return iVec2.x == this.u1 || iVec2.x == this.u2 || iVec2.y == this.v1 || iVec2.y == this.v2;
    }

    protected boolean isPointLeftEdge(IVec2 iVec2) {
        return iVec2.x == this.u1;
    }

    protected boolean isPointRightEdge(IVec2 iVec2) {
        return iVec2.x == this.u2;
    }

    protected boolean isPointBottomEdge(IVec2 iVec2) {
        return iVec2.y == this.v1;
    }

    protected boolean isPointTopEdge(IVec2 iVec2) {
        return iVec2.y == this.v2;
    }

    public IVec2 intersectWithEdge(IVec2 iVec2, IVec2 iVec22) {
        if (iVec22.x <= this.u1) {
            if (iVec22.y == this.v1 && iVec2.y == this.v1 || iVec22.y == this.v2 && iVec2.y == this.v2) {
                return iVec2;
            }
            IVec2 iVec23 = null;
            if (iVec22.x == this.u1) {
                if (iVec2.x == this.u1) {
                    return iVec2;
                }
                iVec23 = iVec22;
            } else {
                iVec23 = this.intersectOnLeft(iVec2, iVec22);
            }
            if (iVec23.y < this.v1) {
                return this.intersectOnBottom(iVec2, iVec22);
            }
            if (iVec23.y > this.v2) {
                return this.intersectOnTop(iVec2, iVec22);
            }
            return iVec23;
        }
        if (iVec22.x >= this.u2) {
            if (iVec22.y == this.v1 && iVec2.y == this.v1 || iVec22.y == this.v2 && iVec2.y == this.v2) {
                return iVec2;
            }
            IVec2 iVec24 = null;
            if (iVec22.x == this.u2) {
                if (iVec2.x == this.u2) {
                    return iVec2;
                }
                iVec24 = iVec22;
            } else {
                iVec24 = this.intersectOnRight(iVec2, iVec22);
            }
            if (iVec24 == null) {
                IOut.err("no intersection found");
                return iVec24;
            }
            if (iVec24.y < this.v1) {
                return this.intersectOnBottom(iVec2, iVec22);
            }
            if (iVec24.y > this.v2) {
                return this.intersectOnTop(iVec2, iVec22);
            }
            return iVec24;
        }
        if (iVec22.y <= this.v1) {
            if (iVec22.y == this.v1) {
                if (iVec2.y == this.v1) {
                    return iVec2;
                }
                return iVec22;
            }
            return this.intersectOnBottom(iVec2, iVec22);
        }
        if (iVec22.y >= this.v2) {
            if (iVec22.y == this.v2) {
                if (iVec2.y == this.v2) {
                    return iVec2;
                }
                return iVec22;
            }
            return this.intersectOnTop(iVec2, iVec22);
        }
        IOut.err("no intersection found");
        return null;
    }

    public boolean equals(int n, int n2) {
        return this.uindex == n && this.vindex == n2;
    }

    public void addIfNoClosePoint(ArrayList<EdgePoint> arrayList, EdgePoint edgePoint, double d) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(Math.abs(arrayList.get((int)i).point.x - edgePoint.point.x) < d) || !(Math.abs(arrayList.get((int)i).point.y - edgePoint.point.y) < d)) continue;
            bl = true;
            arrayList.get((int)i).point.x = edgePoint.point.x;
            arrayList.get((int)i).point.y = edgePoint.point.y;
        }
        if (!bl) {
            arrayList.add(edgePoint);
        }
    }

    public void setupLoop() {
        if (this.trimCurves == null || this.trimCurves.size() == 0) {
            if (!this.outerTrimAdded) {
                this.addTrimLoop(new IVec2[]{new IVec2(this.u1, this.v1), new IVec2(this.u2, this.v1), new IVec2(this.u2, this.v2), new IVec2(this.u1, this.v2)}, true);
            }
            return;
        }
        ArrayList<EdgePoint> arrayList = new ArrayList<EdgePoint>();
        for (int i = 0; i < this.trimCurves.size(); ++i) {
            arrayList.add(new EdgePoint(this.trimCurves.get(i)[0], this.trimCurves.get(i), true));
            arrayList.add(new EdgePoint(this.trimCurves.get(i)[this.trimCurves.get(i).length - 1], this.trimCurves.get(i), false));
        }
        this.addIfNoClosePoint(arrayList, new EdgePoint(new IVec2(this.u1, this.v1), null, true), subsurfaceResolution);
        this.addIfNoClosePoint(arrayList, new EdgePoint(new IVec2(this.u2, this.v1), null, true), subsurfaceResolution);
        this.addIfNoClosePoint(arrayList, new EdgePoint(new IVec2(this.u2, this.v2), null, true), subsurfaceResolution);
        this.addIfNoClosePoint(arrayList, new EdgePoint(new IVec2(this.u1, this.v2), null, true), subsurfaceResolution);
        ISort.sort(arrayList, new EdgePointComparator(this));
        EdgePoint edgePoint = this.findStartPoint(arrayList);
        boolean bl = false;
        while (arrayList.size() > 0 && edgePoint != null && !bl) {
            IVec2[] iVec2Array = this.extractLoop(arrayList, edgePoint);
            if (iVec2Array == null) {
                bl = true;
                continue;
            }
            if (iVec2Array.length > 2) {
                this.addTrimLoop(iVec2Array, false);
            } else {
                IOut.err("too short loop");
            }
            edgePoint = this.findStartPoint(arrayList);
        }
        if (arrayList.size() > 0) {
            boolean bl2 = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get((int)i).polyline == null) continue;
                bl2 = true;
            }
            if (bl2) {
                IOut.err("some points remaining for loops");
            }
        }
    }

    public EdgePoint findStartPoint(ArrayList<EdgePoint> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get((int)i).polyline == null || !arrayList.get((int)i).start) continue;
            return arrayList.get(i);
        }
        return null;
    }

    public EdgePoint extractEndPoint(ArrayList<EdgePoint> arrayList, IVec2[] iVec2Array) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get((int)i).polyline != iVec2Array || arrayList.get((int)i).point != iVec2Array[iVec2Array.length - 1] || arrayList.get((int)i).start) continue;
            return arrayList.get(i);
        }
        IOut.err("no end point found: polyline.length=" + iVec2Array.length + ", polyline[" + (iVec2Array.length - 1) + "] = " + iVec2Array[iVec2Array.length - 1]);
        return null;
    }

    public IVec2[] extractLoop(ArrayList<EdgePoint> arrayList, EdgePoint edgePoint) {
        Object object;
        ArrayList<IVec2> arrayList2 = new ArrayList<IVec2>();
        boolean bl = false;
        EdgePoint edgePoint2 = edgePoint;
        while (arrayList.size() > 0 && !bl) {
            for (int i = 0; i < edgePoint2.polyline.length; ++i) {
                arrayList2.add(edgePoint2.polyline[i]);
            }
            object = this.extractEndPoint(arrayList, edgePoint2.polyline);
            ArrayList<EdgePoint> arrayList3 = this.getNextStartPoint(arrayList, (EdgePoint)object, edgePoint);
            if (arrayList3 == null) {
                IOut.err("no next segment found");
                return null;
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                if (i == arrayList3.size() - 1 && arrayList3.get(i) == edgePoint) {
                    bl = true;
                    continue;
                }
                arrayList2.add(arrayList3.get((int)i).point);
            }
            if (bl) continue;
            edgePoint2 = arrayList3.get(arrayList3.size() - 1);
            arrayList.remove(edgePoint2);
        }
        object = new ArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (((IVec2)arrayList2.get((int)i)).x == ((IVec2)arrayList2.get((int)((i + 1) % arrayList2.size()))).x && ((IVec2)arrayList2.get((int)i)).y == ((IVec2)arrayList2.get((int)((i + 1) % arrayList2.size()))).y) continue;
            ((ArrayList)object).add(arrayList2.get(i));
        }
        return ((ArrayList)object).toArray(new IVec2[((ArrayList)object).size()]);
    }

    public ArrayList<EdgePoint> getNextStartPoint(ArrayList<EdgePoint> arrayList, EdgePoint edgePoint, EdgePoint edgePoint2) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = arrayList.indexOf(edgePoint);
        boolean bl = true;
        for (int i = n3 - 1; i >= 0 && bl; --i) {
            if (arrayList.get((int)i).point.x == edgePoint.point.x && arrayList.get((int)i).point.y == edgePoint.point.y) {
                n4 = i;
                continue;
            }
            bl = false;
        }
        if (n4 < 0) {
            n4 = n3;
        }
        ArrayList<EdgePoint> arrayList2 = new ArrayList<EdgePoint>();
        if (n4 < n3 || edgePoint.point.x == arrayList.get((int)((n4 + 1) % arrayList.size())).point.x && edgePoint.point.y == arrayList.get((int)((n4 + 1) % arrayList.size())).point.y) {
            n2 = n4;
            for (n = 0; n < arrayList.size() && (n4 + n == n3 || arrayList.get((int)((n4 + n) % arrayList.size())).point.x == edgePoint.point.x && arrayList.get((int)((n4 + n) % arrayList.size())).point.y == edgePoint.point.y); ++n) {
                n2 = n4 + n;
                if (n2 == n3 || arrayList.get((int)(n2 % arrayList.size())).polyline == null || !arrayList.get((int)(n2 % arrayList.size())).start || !IDelaunay2D.isFaceDirectionOnEdgeCorrect(edgePoint.polyline[edgePoint.polyline.length - 2], edgePoint.point, arrayList.get((int)(n2 % arrayList.size())).polyline[1])) continue;
                arrayList2.add(arrayList.get(n2 % arrayList.size()));
                arrayList.remove(arrayList2.get(arrayList2.size() - 1));
                arrayList.remove(edgePoint);
                return arrayList2;
            }
            n4 = n2 + 1;
        }
        n2 = 0;
        for (n = 0; n < arrayList.size() && n2 == 0; ++n) {
            if (n4 + n == n3) continue;
            EdgePoint edgePoint3 = arrayList.get((n4 + n) % arrayList.size());
            if (edgePoint3.polyline != null && !edgePoint3.start) continue;
            arrayList2.add(edgePoint3);
            if (edgePoint3.polyline == null || !edgePoint3.start) continue;
            n2 = 1;
        }
        if (arrayList2.get(arrayList2.size() - 1) != edgePoint2 && ((EdgePoint)arrayList2.get((int)(arrayList2.size() - 1))).point.x == edgePoint2.point.x && arrayList2.get((int)(arrayList2.size() - 1)).point.y == edgePoint2.point.y) {
            arrayList2.set(arrayList2.size() - 1, edgePoint2);
        }
        arrayList.remove(n3);
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.remove(arrayList2.get(n));
        }
        if (n2 == 0) {
            IOut.err("no start point found");
            return null;
        }
        return arrayList2;
    }

    public IVec2[][] getDefaultTriangles() {
        IVec2 iVec2 = new IVec2(this.u1, this.v1);
        IVec2 iVec22 = new IVec2(this.u1, this.v2);
        IVec2 iVec23 = new IVec2(this.u2, this.v1);
        IVec2 iVec24 = new IVec2(this.u2, this.v2);
        IVec2[][] iVec2Array = new IVec2[2][3];
        iVec2Array[0][0] = iVec2;
        iVec2Array[0][1] = iVec23;
        iVec2Array[0][2] = iVec24;
        iVec2Array[1][0] = iVec2;
        iVec2Array[1][1] = iVec24;
        iVec2Array[1][2] = iVec22;
        return iVec2Array;
    }

    public boolean isDefaultTrim(IVec2[] iVec2Array) {
        if (iVec2Array.length != 4) {
            return false;
        }
        int n = -1;
        for (int i = 0; i < 4 && n < 0; ++i) {
            if (iVec2Array[i].x != this.u1 || iVec2Array[i].y != this.v1) continue;
            n = i;
        }
        if (n < 0) {
            return false;
        }
        return iVec2Array[(n + 1) % 4].x == this.u2 && iVec2Array[(n + 1) % 4].y == this.v1 && iVec2Array[(n + 2) % 4].x == this.u2 && iVec2Array[(n + 2) % 4].y == this.v2 && iVec2Array[(n + 3) % 4].x == this.u1 && iVec2Array[(n + 3) % 4].y == this.v2;
    }

    public static boolean isOuterLoop(IVec2[] iVec2Array) {
        return IPolyline2D.isNormalPositive(iVec2Array, true);
    }

    public static IVec2[][] getTrianglesOfQuadrilateral(IVec2[] iVec2Array) {
        IVec2[][] iVec2Array2 = new IVec2[2][];
        if (iVec2Array[0].dist(iVec2Array[2]) <= iVec2Array[1].dist(iVec2Array[3])) {
            iVec2Array2[0] = new IVec2[]{iVec2Array[0], iVec2Array[1], iVec2Array[2]};
            iVec2Array2[1] = new IVec2[]{iVec2Array[0], iVec2Array[2], iVec2Array[3]};
            return iVec2Array2;
        }
        iVec2Array2[0] = new IVec2[]{iVec2Array[0], iVec2Array[1], iVec2Array[3]};
        iVec2Array2[1] = new IVec2[]{iVec2Array[1], iVec2Array[2], iVec2Array[3]};
        return iVec2Array2;
    }

    public static IVec2[] removeDuplicatedPoints(IVec2[] iVec2Array) {
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
        arrayList.add(iVec2Array[0]);
        for (int i = 1; i < iVec2Array.length; ++i) {
            if (iVec2Array[i - 1].x == iVec2Array[i].x && iVec2Array[i - 1].y == iVec2Array[i].y) continue;
            arrayList.add(iVec2Array[i]);
        }
        return arrayList.toArray(new IVec2[arrayList.size()]);
    }

    public void removeDuplicatedPointsInLoops() {
        if (this.trimLoops == null) {
            return;
        }
        for (int i = 0; i < this.trimLoops.size(); ++i) {
            IVec2[] iVec2Array = this.trimLoops.get(i);
            boolean bl = false;
            for (int j = 0; j < iVec2Array.length && !bl; ++j) {
                if (iVec2Array[i].x != iVec2Array[(i + 1) % iVec2Array.length].x || iVec2Array[i].y != iVec2Array[(i + 1) % iVec2Array.length].y) continue;
                bl = true;
            }
            if (!bl) continue;
            this.trimLoops.set(i, ISubsurfaceMesh.removeDuplicatedPoints(iVec2Array));
        }
    }

    public IVec2[][] getTriangles() {
        if (this.trimLoops == null || this.trimLoops.size() == 0) {
            return null;
        }
        if (this.trimLoops.size() == 1 && this.trimLoops.get(0).length == 4) {
            if (this.isDefaultTrim(this.trimLoops.get(0))) {
                return null;
            }
            if (ISubsurfaceMesh.isOuterLoop(this.trimLoops.get(0))) {
                return ISubsurfaceMesh.getTrianglesOfQuadrilateral(this.trimLoops.get(0));
            }
        }
        boolean bl = false;
        for (int i = 0; i < this.trimLoops.size() && !bl; ++i) {
            if (ISubsurfaceMesh.isOuterLoop(this.trimLoops.get(i))) continue;
            bl = true;
        }
        if (!bl) {
            ArrayList<IVec2[]> arrayList = new ArrayList<IVec2[]>();
            for (int i = 0; i < this.trimLoops.size(); ++i) {
                IVec2[][] iVec2Array;
                IVec2[] iVec2Array2 = this.trimLoops.get(i);
                if (iVec2Array2.length == 3) {
                    arrayList.add(iVec2Array2);
                    continue;
                }
                if (iVec2Array2.length == 4) {
                    iVec2Array = ISubsurfaceMesh.getTrianglesOfQuadrilateral(iVec2Array2);
                    arrayList.add(iVec2Array[0]);
                    arrayList.add(iVec2Array[1]);
                    continue;
                }
                if (iVec2Array2.length <= 4) continue;
                iVec2Array = IDelaunay2D.getTriangles(null, new IVec2[][]{iVec2Array2});
                for (int j = 0; j < iVec2Array.length; ++j) {
                    arrayList.add(iVec2Array[j]);
                }
            }
            return (IVec2[][])arrayList.toArray((T[])new IVec2[arrayList.size()][]);
        }
        return IDelaunay2D.getTriangles(null, (IVec2[][])this.trimLoops.toArray((T[])new IVec2[this.trimLoops.size()][]));
    }

    public String toString() {
        return "index<" + this.uindex + "," + this.vindex + ">, location<(" + this.u1 + "," + this.v1 + "),(" + this.u2 + "," + this.v2 + ")>";
    }

    public static class SubsurfaceMatrix {
        public ISubsurfaceMesh[][] matrix;
        public double[] uvalues;
        public double[] vvalues;
        public int unum;
        public int vnum;
        public ArrayList<IVec2[]> innerLoop = null;
        public ArrayList<IVec2[]> outerLoop = null;

        public SubsurfaceMatrix(double[] dArray, double[] dArray2) {
            this.unum = dArray.length - 1;
            this.vnum = dArray2.length - 1;
            this.uvalues = dArray;
            this.vvalues = dArray2;
            this.matrix = new ISubsurfaceMesh[this.unum][this.vnum];
        }

        public boolean isInsideTrimLoop(int n, int n2) {
            int n3;
            if (!(this.innerLoop != null && this.innerLoop.size() != 0 || this.outerLoop != null && this.outerLoop.size() != 0)) {
                return true;
            }
            IVec2 iVec2 = new IVec2((this.uvalues[n] + this.uvalues[n + 1]) / 2.0, (this.vvalues[n2] + this.vvalues[n2 + 1]) / 2.0);
            if (this.innerLoop != null && this.innerLoop.size() > 0) {
                for (n3 = 0; n3 < this.innerLoop.size(); ++n3) {
                    if (!iVec2.isInside(this.innerLoop.get(n3))) continue;
                    return false;
                }
            }
            if (this.outerLoop != null && this.outerLoop.size() > 0) {
                for (n3 = 0; n3 < this.outerLoop.size(); ++n3) {
                    if (!iVec2.isInside(this.outerLoop.get(n3))) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public IVec2[][] getTriangles() {
            ArrayList<IVec2[]> arrayList = new ArrayList<IVec2[]>();
            for (int i = 0; i < this.unum; ++i) {
                for (int j = 0; j < this.vnum; ++j) {
                    int n;
                    IVec2[][] iVec2Array;
                    if (this.matrix[i][j] != null) {
                        this.matrix[i][j].setupLoop();
                        iVec2Array = this.matrix[i][j].getTriangles();
                        if (iVec2Array == null && this.isInsideTrimLoop(i, j)) {
                            iVec2Array = this.matrix[i][j].getDefaultTriangles();
                        }
                        if (iVec2Array == null) continue;
                        for (n = 0; n < iVec2Array.length; ++n) {
                            arrayList.add(iVec2Array[n]);
                        }
                        continue;
                    }
                    if (!this.isInsideTrimLoop(i, j)) continue;
                    iVec2Array = this.getSubsurface(i, j).getDefaultTriangles();
                    for (n = 0; n < iVec2Array.length; ++n) {
                        arrayList.add(iVec2Array[n]);
                    }
                }
            }
            return (IVec2[][])arrayList.toArray((T[])new IVec2[arrayList.size()][]);
        }

        public ISubsurfaceMesh getSubsurface(int n, int n2) {
            if (n < 0 || n >= this.matrix.length || n2 < 0 || n2 >= this.matrix[0].length) {
                return new ISubsurfaceMesh(n, n2);
            }
            if (this.matrix[n][n2] == null) {
                this.matrix[n][n2] = new ISubsurfaceMesh(n, n2, this.uvalues[n], this.uvalues[n + 1], this.vvalues[n2], this.vvalues[n2 + 1]);
            }
            return this.matrix[n][n2];
        }

        public boolean isSubsurfaceNull(int n, int n2) {
            return this.matrix[n][n2] == null;
        }

        public boolean isDefaultOuterLoop(IVec2[] iVec2Array) {
            if (iVec2Array.length != 4) {
                return false;
            }
            int n = -1;
            for (int i = 0; i < 4 && n < 0; ++i) {
                if (iVec2Array[i].x != 0.0 || iVec2Array[i].y != 0.0) continue;
                n = i;
            }
            if (n < 0) {
                return false;
            }
            if (iVec2Array[(n + 1) % 4].x != 1.0 || iVec2Array[(n + 1) % 4].y != 0.0) {
                return false;
            }
            if (iVec2Array[(n + 2) % 4].x != 1.0 || iVec2Array[(n + 2) % 4].y != 1.0) {
                return false;
            }
            return iVec2Array[(n + 3) % 4].x == 0.0 && iVec2Array[(n + 3) % 4].y == 1.0;
        }

        public void setLoop(IVec2[] iVec2Array, boolean bl) {
            if (this.isDefaultOuterLoop(iVec2Array)) {
                return;
            }
            if (bl) {
                if (this.outerLoop == null) {
                    this.outerLoop = new ArrayList();
                }
                this.outerLoop.add(iVec2Array);
            } else {
                if (this.innerLoop == null) {
                    this.innerLoop = new ArrayList();
                }
                this.innerLoop.add(iVec2Array);
            }
            ISubsurfaceMesh iSubsurfaceMesh = this.getSubsurfaceOnPoint(iVec2Array[0]);
            int n = -1;
            for (int i = 0; i < iVec2Array.length && n < 0; ++i) {
                ISubsurfaceMesh iSubsurfaceMesh2 = this.getSubsurfaceOnPoint(iVec2Array[(i + 1) % iVec2Array.length]);
                if (iSubsurfaceMesh == iSubsurfaceMesh2) continue;
                n = i;
                iSubsurfaceMesh = iSubsurfaceMesh2;
            }
            if (n < 0) {
                iSubsurfaceMesh.addTrimLoop(iVec2Array, bl);
                return;
            }
            ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
            for (int i = 0; i < iVec2Array.length; ++i) {
                arrayList.add(iVec2Array[(i + n) % iVec2Array.length]);
                ISubsurfaceMesh iSubsurfaceMesh3 = this.getSubsurfaceOnPoint(iVec2Array[(i + n + 1) % iVec2Array.length]);
                if (i != 0 && iSubsurfaceMesh == iSubsurfaceMesh3) continue;
                this.getSubsurfaceOnLine(iVec2Array[(i + n) % iVec2Array.length], iVec2Array[(i + n + 1) % iVec2Array.length]);
                if (i <= 0) continue;
                arrayList.add(iVec2Array[(i + n + 1) % iVec2Array.length]);
                iSubsurfaceMesh.addTrimPolyline(arrayList);
                arrayList = new ArrayList();
                arrayList.add(iVec2Array[(i + n) % iVec2Array.length]);
                iSubsurfaceMesh = iSubsurfaceMesh3;
            }
            arrayList.add(iVec2Array[n]);
            arrayList.add(iVec2Array[(n + 1) % iVec2Array.length]);
            iSubsurfaceMesh.addTrimPolyline(arrayList);
        }

        protected ISubsurfaceMesh getSubsurfaceOnPoint(IVec2 iVec2) {
            int n = this.getUIndex(iVec2);
            int n2 = this.getVIndex(iVec2);
            return this.getSubsurface(n, n2);
        }

        protected boolean insideIndexRange(ISubsurfaceMesh iSubsurfaceMesh, int n, int n2, int n3, int n4) {
            return iSubsurfaceMesh.uindex >= Math.min(n, n3) && iSubsurfaceMesh.uindex <= Math.max(n, n3) && iSubsurfaceMesh.vindex >= Math.min(n2, n4) && iSubsurfaceMesh.vindex <= Math.max(n2, n4);
        }

        protected ISubsurfaceMesh[] getSubsurfaceOnLine(IVec2 iVec2, IVec2 iVec22) {
            int n = this.getUIndex(iVec2);
            int n2 = this.getVIndex(iVec2);
            int n3 = this.getUIndex(iVec22);
            int n4 = this.getVIndex(iVec22);
            if (n == n3 && n2 == n4) {
                return null;
            }
            if (n == n3) {
                if (Math.abs(n2 - n4) == 1) {
                    return null;
                }
                int n5 = 1;
                if (n2 > n4) {
                    n5 = -1;
                }
                int n6 = Math.abs(n2 - n4) - 1;
                ISubsurfaceMesh[] iSubsurfaceMeshArray = new ISubsurfaceMesh[n6];
                for (int i = 0; i < n6; ++i) {
                    ISubsurfaceMesh iSubsurfaceMesh = this.getSubsurface(n, n2 + (i + 1) * n5);
                    iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                    iSubsurfaceMeshArray[i] = iSubsurfaceMesh;
                }
                return iSubsurfaceMeshArray;
            }
            if (n2 == n4) {
                if (Math.abs(n - n3) == 1) {
                    return null;
                }
                int n7 = 1;
                if (n > n3) {
                    n7 = -1;
                }
                int n8 = Math.abs(n - n3) - 1;
                ISubsurfaceMesh[] iSubsurfaceMeshArray = new ISubsurfaceMesh[n8];
                for (int i = 0; i < n8; ++i) {
                    ISubsurfaceMesh iSubsurfaceMesh = this.getSubsurface(n + (i + 1) * n7, n2);
                    iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                    iSubsurfaceMeshArray[i] = iSubsurfaceMesh;
                }
                return iSubsurfaceMeshArray;
            }
            int n9 = n;
            int n10 = n2;
            ISubsurfaceMesh iSubsurfaceMesh = this.getNextSubsurfaceOnLine(iVec2, iVec22, n, n2);
            ArrayList<ISubsurfaceMesh> arrayList = new ArrayList<ISubsurfaceMesh>();
            while (iSubsurfaceMesh != null && !iSubsurfaceMesh.equals(n3, n4) && this.insideIndexRange(iSubsurfaceMesh, n, n2, n3, n4)) {
                ISubsurfaceMesh iSubsurfaceMesh2 = this.getNextSubsurfaceOnLine(iVec2, iVec22, iSubsurfaceMesh.uindex, iSubsurfaceMesh.vindex);
                this.addDiagonalTrimLine(iVec2, iVec22, iSubsurfaceMesh, n9, n10, iSubsurfaceMesh2.uindex, iSubsurfaceMesh2.vindex);
                arrayList.add(iSubsurfaceMesh);
                n9 = iSubsurfaceMesh.uindex;
                n10 = iSubsurfaceMesh.vindex;
                if (iSubsurfaceMesh2.uindex < 0 || iSubsurfaceMesh2.uindex > this.matrix.length || iSubsurfaceMesh2.vindex < 0 || iSubsurfaceMesh2.vindex > this.matrix[0].length) {
                    iSubsurfaceMesh2 = null;
                }
                iSubsurfaceMesh = iSubsurfaceMesh2;
            }
            return arrayList.toArray(new ISubsurfaceMesh[arrayList.size()]);
        }

        protected void addDiagonalTrimLine(IVec2 iVec2, IVec2 iVec22, ISubsurfaceMesh iSubsurfaceMesh, int n, int n2, int n3, int n4) {
            if (n == iSubsurfaceMesh.uindex) {
                if (n2 < iSubsurfaceMesh.vindex) {
                    if (n3 == iSubsurfaceMesh.uindex && n4 > iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                        return;
                    }
                    if (n3 < iSubsurfaceMesh.uindex && n4 >= iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addTrimLineAtBottomLeft(iVec2, iVec22);
                        return;
                    }
                    if (n3 > iSubsurfaceMesh.uindex && n4 >= iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addTrimLineAtBottomRight(iVec2, iVec22);
                        return;
                    }
                } else if (n2 > iSubsurfaceMesh.vindex) {
                    if (n3 == iSubsurfaceMesh.uindex && n4 < iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                        return;
                    }
                    if (n3 < iSubsurfaceMesh.uindex && n4 <= iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addTrimLineAtTopLeft(iVec2, iVec22);
                        return;
                    }
                    if (n3 > iSubsurfaceMesh.uindex && n4 <= iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addTrimLineAtTopRight(iVec2, iVec22);
                        return;
                    }
                }
            } else if (n < iSubsurfaceMesh.uindex) {
                if (n2 == iSubsurfaceMesh.vindex) {
                    if (n3 > iSubsurfaceMesh.uindex && n4 == iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                        return;
                    }
                    if (n3 >= iSubsurfaceMesh.uindex) {
                        if (n4 < iSubsurfaceMesh.vindex) {
                            iSubsurfaceMesh.addTrimLineAtBottomLeft(iVec2, iVec22);
                            return;
                        }
                        if (n4 > iSubsurfaceMesh.vindex) {
                            iSubsurfaceMesh.addTrimLineAtTopLeft(iVec2, iVec22);
                            return;
                        }
                    }
                } else if (n2 < iSubsurfaceMesh.vindex) {
                    if (n3 > iSubsurfaceMesh.uindex && n4 >= iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                        return;
                    }
                    if (n3 == iSubsurfaceMesh.uindex && n4 > iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                        return;
                    }
                } else {
                    if (n3 > iSubsurfaceMesh.uindex && n4 <= iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                        return;
                    }
                    if (n3 == iSubsurfaceMesh.uindex && n4 < iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                        return;
                    }
                }
            } else if (n2 == iSubsurfaceMesh.vindex) {
                if (n3 < iSubsurfaceMesh.uindex && n4 == iSubsurfaceMesh.vindex) {
                    iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                    return;
                }
                if (n3 <= iSubsurfaceMesh.uindex) {
                    if (n4 < iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addTrimLineAtBottomRight(iVec2, iVec22);
                        return;
                    }
                    if (n4 > iSubsurfaceMesh.vindex) {
                        iSubsurfaceMesh.addTrimLineAtTopRight(iVec2, iVec22);
                        return;
                    }
                }
            } else if (n2 < iSubsurfaceMesh.vindex) {
                if (n3 < iSubsurfaceMesh.uindex && n4 >= iSubsurfaceMesh.vindex) {
                    iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                    return;
                }
                if (n3 == iSubsurfaceMesh.uindex && n4 > iSubsurfaceMesh.vindex) {
                    iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                    return;
                }
            } else {
                if (n3 < iSubsurfaceMesh.uindex && n4 <= iSubsurfaceMesh.vindex) {
                    iSubsurfaceMesh.addUTrimLine(iVec2, iVec22);
                    return;
                }
                if (n3 == iSubsurfaceMesh.uindex && n4 < iSubsurfaceMesh.vindex) {
                    iSubsurfaceMesh.addVTrimLine(iVec2, iVec22);
                    return;
                }
            }
            IOut.err("neighboring location is invalid: prev=<" + n + "," + n2 + ">, current=<" + iSubsurfaceMesh.uindex + "," + iSubsurfaceMesh.vindex + ">, next=<" + n3 + "," + n4 + ">");
        }

        protected ISubsurfaceMesh getNextSubsurfaceOnLine(IVec2 iVec2, IVec2 iVec22, int n, int n2) {
            if (iVec2.x < iVec22.x) {
                if (n < this.unum) {
                    if (n2 < this.vnum && this.isLineOnVEdge(iVec2, iVec22, n + 1, n2, n2 + 1)) {
                        return this.getSubsurface(n + 1, n2);
                    }
                    if (this.isLineOnPoint(iVec2, iVec22, n + 1, n2)) {
                        if (n2 > 0 && iVec2.y > iVec22.y) {
                            return this.getSubsurface(n + 1, n2 - 1);
                        }
                        return this.getSubsurface(n + 1, n2);
                    }
                    if (n2 < this.vnum && this.isLineOnPoint(iVec2, iVec22, n + 1, n2 + 1)) {
                        if (iVec2.y < iVec22.y) {
                            return this.getSubsurface(n + 1, n2 + 1);
                        }
                        return this.getSubsurface(n + 1, n2);
                    }
                }
            } else if (n > 0) {
                if (n2 < this.vnum && this.isLineOnVEdge(iVec2, iVec22, n, n2, n2 + 1)) {
                    return this.getSubsurface(n - 1, n2);
                }
                if (n2 > 0 && this.isLineOnPoint(iVec2, iVec22, n, n2)) {
                    if (iVec2.y > iVec22.y) {
                        return this.getSubsurface(n - 1, n2 - 1);
                    }
                    return this.getSubsurface(n - 1, n2);
                }
                if (n2 < this.vnum && this.isLineOnPoint(iVec2, iVec22, n, n2 + 1)) {
                    if (iVec2.y < iVec22.y) {
                        return this.getSubsurface(n - 1, n2 + 1);
                    }
                    return this.getSubsurface(n - 1, n2);
                }
            }
            if (iVec2.y < iVec22.y) {
                if (n2 < this.vnum) {
                    if (n < this.unum && this.isLineOnUEdge(iVec2, iVec22, n, n + 1, n2 + 1)) {
                        return this.getSubsurface(n, n2 + 1);
                    }
                    if (this.isLineOnPoint(iVec2, iVec22, n, n2 + 1)) {
                        if (iVec2.x > iVec22.x) {
                            return this.getSubsurface(n - 1, n2 + 1);
                        }
                        return this.getSubsurface(n, n2 + 1);
                    }
                    if (n < this.unum && this.isLineOnPoint(iVec2, iVec22, n + 1, n2 + 1)) {
                        if (iVec2.x < iVec22.x) {
                            return this.getSubsurface(n + 1, n2 + 1);
                        }
                        return this.getSubsurface(n, n2 + 1);
                    }
                }
            } else if (n2 > 0) {
                if (n < this.unum && this.isLineOnUEdge(iVec2, iVec22, n, n + 1, n2)) {
                    return this.getSubsurface(n, n2 - 1);
                }
                if (this.isLineOnPoint(iVec2, iVec22, n, n2)) {
                    if (iVec2.x > iVec22.x) {
                        return this.getSubsurface(n - 1, n2 - 1);
                    }
                    return this.getSubsurface(n, n2 - 1);
                }
                if (n < this.unum && this.isLineOnPoint(iVec2, iVec22, n + 1, n2)) {
                    if (iVec2.x < iVec22.x) {
                        return this.getSubsurface(n + 1, n2 - 1);
                    }
                    return this.getSubsurface(n, n2 - 1);
                }
            }
            return null;
        }

        protected boolean isLineOnPoint(IVec2 iVec2, IVec2 iVec22, int n, int n2) {
            return iVec22.diff((IVec2)iVec2).cross((IVec2)this.getPoint((int)n, (int)n2).diff((IVec2)iVec2)).z == 0.0;
        }

        protected boolean isLineOnEdge(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
            IVec2 iVec25 = iVec22.diff(iVec2);
            double d = iVec25.cross((IVec2)iVec23.diff((IVec2)iVec2)).z;
            double d2 = iVec25.cross((IVec2)iVec24.diff((IVec2)iVec2)).z;
            return d * d2 < 0.0;
        }

        protected boolean isLineOnUEdge(IVec2 iVec2, IVec2 iVec22, int n, int n2, int n3) {
            return this.isLineOnEdge(iVec2, iVec22, this.getPoint(n, n3), this.getPoint(n2, n3));
        }

        protected boolean isLineOnVEdge(IVec2 iVec2, IVec2 iVec22, int n, int n2, int n3) {
            return this.isLineOnEdge(iVec2, iVec22, this.getPoint(n, n2), this.getPoint(n, n3));
        }

        protected int getUIndex(IVec2 iVec2) {
            for (int i = 0; i < this.unum; ++i) {
                if (!(iVec2.x < this.uvalues[i + 1])) continue;
                return i;
            }
            return this.unum - 1;
        }

        protected int getVIndex(IVec2 iVec2) {
            for (int i = 0; i < this.vnum; ++i) {
                if (!(iVec2.y < this.vvalues[i + 1])) continue;
                return i;
            }
            return this.vnum - 1;
        }

        protected double getU(int n) {
            return this.uvalues[n];
        }

        protected double getV(int n) {
            return this.vvalues[n];
        }

        protected IVec2 getPoint(int n, int n2) {
            return new IVec2(this.getU(n), this.getV(n2));
        }

        protected IVec2 getPoint(ISubsurfaceMesh iSubsurfaceMesh) {
            return new IVec2(this.getU(iSubsurfaceMesh.uindex), this.getV(iSubsurfaceMesh.vindex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgePointComparator
    implements IComparator<EdgePoint> {
        public ISubsurfaceMesh surf;

        public EdgePointComparator(ISubsurfaceMesh iSubsurfaceMesh) {
            this.surf = iSubsurfaceMesh;
        }

        public int edgePointIsOn(IVec2 iVec2) {
            boolean bl;
            boolean bl2 = iVec2.y <= (this.surf.v2 - this.surf.v1) / (this.surf.u2 - this.surf.u1) * (iVec2.x - this.surf.u1) + this.surf.v1;
            boolean bl3 = bl = iVec2.y <= (this.surf.v1 - this.surf.v2) / (this.surf.u2 - this.surf.u1) * (iVec2.x - this.surf.u1) + this.surf.v2;
            if (bl2) {
                if (bl) {
                    return 0;
                }
                return 1;
            }
            if (bl) {
                return 3;
            }
            return 2;
        }

        public double distanceOnLoop(IVec2 iVec2) {
            int n = this.edgePointIsOn(iVec2);
            if (n == 0) {
                return iVec2.x - this.surf.u1;
            }
            if (n == 1) {
                return this.surf.u2 - this.surf.u1 + iVec2.y - this.surf.v1;
            }
            if (n == 2) {
                return this.surf.u2 - this.surf.u1 + (this.surf.v2 - this.surf.v1) + (this.surf.u2 - iVec2.x);
            }
            return (this.surf.u2 - this.surf.u1) * 2.0 + (this.surf.v2 - this.surf.v1) + (this.surf.v2 - iVec2.y);
        }

        @Override
        public int compare(EdgePoint edgePoint, EdgePoint edgePoint2) {
            double d;
            double d2 = this.distanceOnLoop(edgePoint.point);
            if (d2 < (d = this.distanceOnLoop(edgePoint2.point))) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
    }

    public static class EdgePoint {
        public IVec2 point;
        public boolean start;
        public IVec2[] polyline = null;

        public EdgePoint(IVec2 iVec2, IVec2[] iVec2Array, boolean bl) {
            this.point = iVec2;
            this.polyline = iVec2Array;
            this.start = bl;
        }
    }
}

