/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.ICurveI;
import igeo.IFace;
import igeo.IG;
import igeo.IMeshI;
import igeo.IObject;
import igeo.IOut;
import igeo.IParameterObject;
import igeo.IServer;
import igeo.IServerI;
import igeo.ISurfaceI;
import igeo.ITrimCurve;
import igeo.ITrimCurveI;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVecI;
import igeo.IVertex;
import igeo.gui.ITrimLoopGraphic;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IObjFileExporter {
    public static final int maxColumn = 20;
    protected int vertexNumber;
    protected int parametricVertexNumber;
    protected int textureVertexNumber;
    protected int normalVertexNumber;
    protected int objectNumber;
    protected int curve2DNumber;
    protected NumberFormat f;
    protected HashMap<IVertex, int[]> vertexMap;

    public void init() {
        this.vertexNumber = 1;
        this.parametricVertexNumber = 1;
        this.textureVertexNumber = 1;
        this.normalVertexNumber = 1;
        this.objectNumber = 1;
        this.curve2DNumber = 1;
        this.f = NumberFormat.getInstance();
        if (this.f instanceof DecimalFormat) {
            ((DecimalFormat)this.f).setDecimalSeparatorAlwaysShown(false);
            ((DecimalFormat)this.f).setMaximumFractionDigits(100);
            ((DecimalFormat)this.f).setMinimumFractionDigits(0);
            ((DecimalFormat)this.f).setGroupingUsed(false);
        } else {
            IOut.p("ERROR: fail to get DecimalFormat");
        }
    }

    public static boolean write(String string, IServerI iServerI) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (printStream == null) {
            IOut.p("ERROR: file coundn't be opened: " + string);
            return false;
        }
        IObjFileExporter iObjFileExporter = new IObjFileExporter();
        iObjFileExporter.write(printStream, iServerI);
        printStream.close();
        return true;
    }

    public static boolean write(File file, IServerI iServerI) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (printStream == null) {
            IOut.p("ERROR: file coundn't be opened: " + file);
            return false;
        }
        IObjFileExporter iObjFileExporter = new IObjFileExporter();
        iObjFileExporter.write(printStream, iServerI);
        printStream.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PrintStream printStream, IServerI iServerI) {
        IServer iServer = iServerI.server();
        Object object = IG.lock;
        synchronized (object) {
            this.init();
            for (int i = 0; i < iServer.objectNum(); ++i) {
                IObject iObject;
                if (i % 100 == 0 && i > 0) {
                    IOut.debug(1, i + "/" + iServer.objectNum());
                }
                if ((iObject = iServer.getObject(i)) instanceof IVecI) {
                    printStream.println("g group_" + this.objectNumber);
                    printStream.println("o object_" + this.objectNumber);
                    this.writePoint(printStream, (IVecI)((Object)iObject));
                    ++this.objectNumber;
                    continue;
                }
                if (iObject instanceof ICurveI) {
                    printStream.println("g group_" + this.objectNumber);
                    printStream.println("o object_" + this.objectNumber);
                    this.writeCurve(printStream, (ICurveI)((Object)iObject));
                    ++this.objectNumber;
                    continue;
                }
                if (iObject instanceof ISurfaceI) {
                    printStream.println("g group_" + this.objectNumber);
                    printStream.println("o object_" + this.objectNumber);
                    this.writeSurface(printStream, (ISurfaceI)((Object)iObject));
                    ++this.objectNumber;
                    continue;
                }
                if (iObject instanceof IMeshI) {
                    printStream.println("g group_" + this.objectNumber);
                    printStream.println("o object_" + this.objectNumber);
                    this.writeMesh(printStream, (IMeshI)((Object)iObject));
                    ++this.objectNumber;
                    continue;
                }
                IOut.p("Warning: " + iObject + "-" + iObject.parameter + " is not saved");
            }
        }
    }

    public void writePoint(PrintStream printStream, IVecI iVecI) {
        int n;
        int n2 = 1;
        double[] dArray = new double[]{0.0, 1.0};
        double d = 0.0;
        double d2 = 1.0;
        IVec iVec = iVecI.get();
        IVec[] iVecArray = new IVec[]{iVec, iVec};
        for (n = 0; n < iVecArray.length; ++n) {
            printStream.println("v " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y) + " " + this.f.format(iVecArray[n].z));
        }
        printStream.println("cstype bspline");
        printStream.println("deg " + n2);
        printStream.print("curv " + d + " " + d2);
        n = 1;
        while (n <= iVecArray.length) {
            printStream.print(" " + this.vertexNumber);
            ++n;
            ++this.vertexNumber;
        }
        printStream.println();
        printStream.print("parm u");
        for (n = 0; n < dArray.length; ++n) {
            printStream.print(" " + this.f.format(dArray[n]));
        }
        printStream.println();
        printStream.println("end");
    }

    public void writeCurve(PrintStream printStream, ICurveI iCurveI) {
        int n;
        int n2;
        int n3 = iCurveI.deg();
        double[] dArray = new double[iCurveI.knotNum()];
        double d = iCurveI.ustart();
        double d2 = iCurveI.uend();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = d != 0.0 || d2 != 1.0 ? iCurveI.knot(n2) * (d2 - d) + d : iCurveI.knot(n2);
        }
        n2 = 0;
        IVec[] iVecArray = new IVec[iCurveI.cpNum()];
        for (n = 0; n < iVecArray.length; ++n) {
            iVecArray[n] = iCurveI.cp(n).get();
            if (!(iVecArray[n] instanceof IVec4) || ((IVec4)iVecArray[n]).w == 1.0) continue;
            n2 = 1;
        }
        for (n = 0; n < iVecArray.length; ++n) {
            if (n2 != 0) {
                if (iVecArray[n] instanceof IVec4) {
                    printStream.println("v " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y) + " " + this.f.format(iVecArray[n].z) + " " + this.f.format(((IVec4)iVecArray[n]).w));
                    continue;
                }
                printStream.println("v " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y) + " " + this.f.format(iVecArray[n].z) + " 1.0");
                continue;
            }
            printStream.println("v " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y) + " " + this.f.format(iVecArray[n].z));
        }
        if (n2 != 0) {
            printStream.println("cstype rat bspline");
        } else {
            printStream.println("cstype bspline");
        }
        printStream.println("deg " + n3);
        printStream.print("curv " + d + " " + d2);
        n = 1;
        while (n <= iVecArray.length) {
            printStream.print(" " + this.vertexNumber);
            if (n % 20 == 0 && n != iVecArray.length) {
                printStream.println(" \\");
            }
            ++n;
            ++this.vertexNumber;
        }
        printStream.println();
        printStream.print("parm u");
        for (n = 0; n < dArray.length; ++n) {
            printStream.print(" " + this.f.format(dArray[n]));
            if (n % 20 != 0 || n == 0 || n == dArray.length - 1) continue;
            printStream.println(" \\");
        }
        printStream.println();
        printStream.println("end");
    }

    public static void checkTrimLoopDirection(ArrayList<ArrayList<ITrimCurveI>> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ITrimCurveI[] iTrimCurveIArray = arrayList.get(i).toArray(new ITrimCurveI[arrayList.get(i).size()]);
            ITrimLoopGraphic iTrimLoopGraphic = new ITrimLoopGraphic(iTrimCurveIArray, bl, 1);
            if (!iTrimLoopGraphic.reversed()) continue;
            ArrayList<ITrimCurveI> arrayList2 = new ArrayList<ITrimCurveI>();
            for (int j = 0; j < iTrimCurveIArray.length; ++j) {
                arrayList2.add(iTrimCurveIArray[iTrimCurveIArray.length - 1 - j].rev());
            }
            arrayList.set(i, arrayList2);
        }
    }

    public void writeSurface(PrintStream printStream, ISurfaceI iSurfaceI) {
        ITrimCurveI iTrimCurveI;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        int n7;
        int n8 = iSurfaceI.ucpNum();
        int n9 = iSurfaceI.vcpNum();
        ArrayList<ArrayList<ITrimCurveI>> arrayList = new ArrayList<ArrayList<ITrimCurveI>>();
        ArrayList<ArrayList<ITrimCurveI>> arrayList2 = new ArrayList<ArrayList<ITrimCurveI>>();
        if (!iSurfaceI.hasOuterTrim() && iSurfaceI.hasInnerTrim()) {
            ArrayList<ITrimCurve> arrayList3 = new ArrayList<ITrimCurve>();
            arrayList3.add(new ITrimCurve(new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0)).surface(iSurfaceI));
            arrayList3.add(new ITrimCurve(new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0)).surface(iSurfaceI));
            arrayList3.add(new ITrimCurve(new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)).surface(iSurfaceI));
            arrayList3.add(new ITrimCurve(new IVec(0.0, 1.0, 0.0), new IVec(0.0, 0.0, 0.0)).surface(iSurfaceI));
            arrayList.add(arrayList3);
        }
        for (n7 = 0; n7 < iSurfaceI.outerTrimLoopNum(); ++n7) {
            object = new ArrayList<ITrimCurveI>();
            for (n6 = 0; n6 < iSurfaceI.outerTrimNum(n7); ++n6) {
                ((ArrayList)object).add(iSurfaceI.outerTrim(n7, n6));
            }
            arrayList.add((ArrayList<ITrimCurveI>)object);
        }
        for (n7 = 0; n7 < iSurfaceI.innerTrimLoopNum(); ++n7) {
            object = new ArrayList();
            for (n6 = 0; n6 < iSurfaceI.innerTrimNum(n7); ++n6) {
                ((ArrayList)object).add(iSurfaceI.innerTrim(n7, n6));
            }
            arrayList2.add((ArrayList<ITrimCurveI>)object);
        }
        IObjFileExporter.checkTrimLoopDirection(arrayList, true);
        IObjFileExporter.checkTrimLoopDirection(arrayList2, false);
        Object object2 = null;
        object = null;
        if (arrayList.size() > 0) {
            object2 = new int[arrayList.size()][];
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                object2[n6] = new int[arrayList.get(n6).size()];
                for (n5 = 0; n5 < arrayList.get(n6).size(); ++n5) {
                    object2[n6][n5] = this.curve2DNumber;
                    this.writeTrimCurve(printStream, arrayList.get(n6).get(n5));
                }
            }
        }
        if (arrayList2.size() > 0) {
            object = new int[arrayList2.size()][];
            for (n6 = 0; n6 < arrayList2.size(); ++n6) {
                object[n6] = new int[arrayList2.get(n6).size()];
                for (n5 = 0; n5 < arrayList2.get(n6).size(); ++n5) {
                    object[n6][n5] = this.curve2DNumber;
                    this.writeTrimCurve(printStream, arrayList2.get(n6).get(n5));
                }
            }
        }
        IVec[][] iVecArray = new IVec[n8][n9];
        n5 = 0;
        for (n4 = 0; n4 < n8; ++n4) {
            for (n3 = 0; n3 < n9; ++n3) {
                iVecArray[n4][n3] = iSurfaceI.cp(n4, n3).get();
                if (!(iVecArray[n4][n3] instanceof IVec4) || ((IVec4)iVecArray[n4][n3]).w == 1.0) continue;
                n5 = 1;
            }
        }
        n4 = iSurfaceI.udeg();
        n3 = iSurfaceI.vdeg();
        double d = iSurfaceI.ustart();
        double d2 = iSurfaceI.uend();
        double d3 = iSurfaceI.vstart();
        double d4 = iSurfaceI.vend();
        double[] dArray = new double[iSurfaceI.uknotNum()];
        double[] dArray2 = new double[iSurfaceI.vknotNum()];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = iSurfaceI.uknot(n2);
            if (d == 0.0 && d2 == 1.0) continue;
            dArray[n2] = (d2 - d) * dArray[n2] + d;
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = iSurfaceI.vknot(n2);
            if (d3 == 0.0 && d4 == 1.0) continue;
            dArray2[n2] = (d4 - d3) * dArray2[n2] + d3;
        }
        for (n2 = 0; n2 < n9; ++n2) {
            for (n = 0; n < n8; ++n) {
                if (n5 != 0) {
                    printStream.println("v " + this.f.format(iVecArray[n][n2].x) + " " + this.f.format(iVecArray[n][n2].y) + " " + this.f.format(iVecArray[n][n2].z) + " " + this.f.format(((IVec4)iVecArray[n][n2]).w));
                    continue;
                }
                printStream.println("v " + this.f.format(iVecArray[n][n2].x) + " " + this.f.format(iVecArray[n][n2].y) + " " + this.f.format(iVecArray[n][n2].z));
            }
        }
        if (n5 != 0) {
            printStream.println("cstype rat bspline");
        } else {
            printStream.println("cstype bspline");
        }
        printStream.println("deg " + n4 + " " + n3);
        printStream.print("surf ");
        printStream.print(this.f.format(d) + " " + this.f.format(d2) + " ");
        printStream.print(this.f.format(d3) + " " + this.f.format(d4));
        n2 = 1;
        while (n2 <= n8 * n9) {
            printStream.print(" " + this.vertexNumber);
            if (n2 % 20 == 0 && n2 != n8 * n9) {
                printStream.println(" \\");
            }
            ++n2;
            ++this.vertexNumber;
        }
        printStream.println();
        printStream.print("parm u");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            printStream.print(" " + this.f.format(dArray[n2]));
            if (n2 % 20 != 0 || n2 == 0 || n2 == dArray.length - 1) continue;
            printStream.println(" \\");
        }
        printStream.println();
        printStream.print("parm v");
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            printStream.print(" " + this.f.format(dArray2[n2]));
            if (n2 % 20 != 0 || n2 == 0 || n2 == dArray2.length - 1) continue;
            printStream.println(" \\");
        }
        printStream.println();
        if (arrayList.size() > 0) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                printStream.print("trim");
                for (n = 0; n < arrayList.get(n2).size(); ++n) {
                    iTrimCurveI = arrayList.get(n2).get(n);
                    printStream.print(" " + this.f.format(iTrimCurveI.ustart()));
                    printStream.print(" " + this.f.format(iTrimCurveI.uend()));
                    printStream.print(" " + object2[n2][n]);
                    if (n <= 0 || n % 10 != 0 || n >= arrayList.get(n2).size() - 1) continue;
                    printStream.println(" \\");
                }
                printStream.println();
            }
        }
        if (arrayList2.size() > 0) {
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                printStream.print("hole");
                for (n = 0; n < arrayList2.get(n2).size(); ++n) {
                    iTrimCurveI = arrayList2.get(n2).get(n);
                    printStream.print(" " + this.f.format(iTrimCurveI.ustart()));
                    printStream.print(" " + this.f.format(iTrimCurveI.uend()));
                    printStream.print(" " + (int)object[n2][n]);
                    if (n <= 0 || n % 10 != 0 || n >= arrayList2.get(n2).size() - 1) continue;
                    printStream.println(" \\");
                }
                printStream.println();
            }
        }
        printStream.println("end");
    }

    public void writeTrimCurve(PrintStream printStream, ITrimCurveI iTrimCurveI) {
        int n;
        int n2 = iTrimCurveI.deg();
        double[] dArray = new double[iTrimCurveI.knotNum()];
        double d = iTrimCurveI.ustart();
        double d2 = iTrimCurveI.uend();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d != 0.0 || d2 != 1.0 ? iTrimCurveI.knot(i) * (d2 - d) + d : iTrimCurveI.knot(i);
        }
        double d3 = iTrimCurveI.surface().ustart();
        double d4 = iTrimCurveI.surface().uend();
        double d5 = iTrimCurveI.surface().vstart();
        double d6 = iTrimCurveI.surface().vend();
        boolean bl = false;
        IVec[] iVecArray = new IVec[iTrimCurveI.cpNum()];
        for (n = 0; n < iVecArray.length; ++n) {
            iVecArray[n] = iTrimCurveI.cp(n).get();
            if (iVecArray[n] instanceof IVec4 && ((IVec4)iVecArray[n]).w != 1.0) {
                bl = true;
            }
            if (d3 != 0.0 || d4 != 1.0) {
                iVecArray[n].x = (d4 - d3) * iVecArray[n].x + d3;
            }
            if (d5 == 0.0 && d6 == 1.0) continue;
            iVecArray[n].y = (d6 - d5) * iVecArray[n].y + d5;
        }
        for (n = 0; n < iVecArray.length; ++n) {
            if (bl) {
                if (iVecArray[n] instanceof IVec4) {
                    printStream.println("vp " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y) + " " + this.f.format(((IVec4)iVecArray[n]).w));
                    continue;
                }
                printStream.println("vp " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y) + " 1.0");
                continue;
            }
            printStream.println("vp " + this.f.format(iVecArray[n].x) + " " + this.f.format(iVecArray[n].y));
        }
        if (bl) {
            printStream.println("cstype rat bspline");
        } else {
            printStream.println("cstype bspline");
        }
        printStream.println("deg " + n2);
        printStream.print("curv2");
        n = 1;
        while (n <= iVecArray.length) {
            printStream.print(" " + this.parametricVertexNumber);
            if (n % 20 == 0 && n != iVecArray.length) {
                printStream.println(" \\");
            }
            ++n;
            ++this.parametricVertexNumber;
        }
        printStream.println();
        printStream.print("parm u");
        for (n = 0; n < dArray.length; ++n) {
            printStream.print(" " + this.f.format(dArray[n]));
            if (n % 20 != 0 || n == 0 || n == dArray.length - 1) continue;
            printStream.println(" \\");
        }
        printStream.println();
        printStream.println("end");
        ++this.curve2DNumber;
    }

    public void writeMesh(PrintStream printStream, IMeshI iMeshI) {
        int n;
        for (n = 0; n < iMeshI.vertexNum(); ++n) {
            this.writeVertex(printStream, iMeshI.vertex(n));
        }
        for (n = 0; n < iMeshI.faceNum(); ++n) {
            this.writeFace(printStream, iMeshI.face(n));
        }
    }

    public void writeVertex(PrintStream printStream, IVertex iVertex) {
        IParameterObject iParameterObject;
        if (this.vertexMap == null) {
            this.vertexMap = new HashMap();
        }
        int[] nArray = new int[3];
        IVec iVec = iVertex.get();
        printStream.println("v " + this.f.format(iVec.x) + " " + this.f.format(iVec.y) + " " + this.f.format(iVec.z));
        nArray[0] = this.vertexNumber++;
        if (iVertex.texture() != null) {
            iParameterObject = iVertex.texture().get();
            printStream.println("vt " + this.f.format(iParameterObject.x) + " " + this.f.format(iParameterObject.y));
            nArray[1] = this.textureVertexNumber++;
        } else {
            nArray[1] = -1;
        }
        if (iVertex.normal() != null) {
            iParameterObject = iVertex.normal().get();
            printStream.println("vn " + this.f.format(((IVec)iParameterObject).x) + " " + this.f.format(((IVec)iParameterObject).y) + " " + this.f.format(((IVec)iParameterObject).z));
            nArray[2] = this.normalVertexNumber++;
        } else {
            nArray[2] = -1;
        }
        this.vertexMap.put(iVertex, nArray);
    }

    public void writeFace(PrintStream printStream, IFace iFace) {
        int n;
        int n2;
        int[][] nArrayArray = new int[iFace.vertexNum()][];
        boolean bl = false;
        if (this.vertexMap == null) {
            bl = true;
        }
        for (n2 = 0; n2 < iFace.vertexNum() && !bl; ++n2) {
            nArrayArray[n2] = this.vertexMap.get(iFace.vertex(n2));
            if (nArrayArray[n2] != null) continue;
            bl = true;
        }
        if (bl) {
            IOut.err("vertex number in a face is not found. the face is not exported.");
            return;
        }
        n2 = 1;
        boolean bl2 = true;
        for (n = 0; n < nArrayArray.length && bl2; ++n) {
            if (nArrayArray[n][1] >= 0) continue;
            bl2 = false;
        }
        for (n = 0; n < nArrayArray.length && n2 != 0; ++n) {
            if (nArrayArray[n][2] >= 0) continue;
            n2 = 0;
        }
        printStream.print("f");
        for (n = 0; n < nArrayArray.length; ++n) {
            printStream.print(" " + nArrayArray[n][0]);
            if (n2 == 0 && !bl2) continue;
            printStream.print("/");
            if (bl2) {
                printStream.print(nArrayArray[n][1]);
            }
            printStream.print("/");
            if (n2 == 0) continue;
            printStream.print(nArrayArray[n][2]);
        }
        printStream.println();
    }
}

