/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IFace;
import igeo.IMeshType;
import igeo.IOut;
import igeo.IVec;
import igeo.IVertex;
import java.util.ArrayList;

public class IEdge {
    public IVertex[] vertices;
    public ArrayList<IFace> faces;

    public IEdge(IVertex iVertex, IVertex iVertex2) {
        this.vertices = new IVertex[2];
        this.vertices[0] = iVertex;
        this.vertices[1] = iVertex2;
        this.faces = new ArrayList();
        iVertex.addEdge(this);
        iVertex2.addEdge(this);
    }

    public IEdge(IEdge iEdge) {
        int n;
        this.vertices = new IVertex[iEdge.vertices.length];
        for (n = 0; n < this.vertices.length; ++n) {
            this.vertices[n] = iEdge.vertices[n];
        }
        this.faces = new ArrayList();
        for (n = 0; n < iEdge.faces.size(); ++n) {
            this.faces.add(iEdge.faces.get(n));
        }
    }

    public IVertex getVertex(int n) {
        return this.vertex(n);
    }

    public IVertex vertex(int n) {
        return this.vertices[n];
    }

    public int vertexNum() {
        return this.vertices.length;
    }

    public void addFace(IFace iFace) {
        this.faces.add(iFace);
    }

    public IFace getFace(int n) {
        return this.face(n);
    }

    public IFace face(int n) {
        return this.faces.get(n);
    }

    public int faceNum() {
        return this.faces.size();
    }

    public IEdge dup() {
        return new IEdge(this);
    }

    public void del() {
        for (int i = 0; i < this.faces.size(); ++i) {
            this.faces.get(i).del();
            --i;
        }
        this.vertices[0].del(this);
        this.vertices[1].del(this);
    }

    public IVec nml(double d) {
        return this.vertices[0].nml().get().mul(1.0 - d).add(this.vertices[1].nml().mul(d)).unit();
    }

    public IVec normal(double d) {
        return this.nml(d);
    }

    public IVec nml() {
        return this.nml(0.5);
    }

    public IVec normal() {
        return this.nml();
    }

    public IVec getPointOnEdge(double d) {
        return this.vertices[0].pos.get().sum(this.vertices[1].pos, d);
    }

    public IVec pos(double d) {
        return this.getPointOnEdge(d);
    }

    public IVec mid() {
        return this.getPointOnEdge(0.5);
    }

    public IVec center() {
        return this.mid();
    }

    public boolean contains(IVertex iVertex) {
        return this.vertices[0] == iVertex || this.vertices[1] == iVertex;
    }

    public boolean contains(IVertex iVertex, IVertex iVertex2) {
        return this.vertices[0] == iVertex && this.vertices[1] == iVertex2 || this.vertices[0] == iVertex2 && this.vertices[1] == iVertex;
    }

    public void replaceVertex(IVertex iVertex, IVertex iVertex2) {
        if (this.vertices[0] == iVertex) {
            this.vertices[0] = iVertex2;
        } else if (this.vertices[1] == iVertex) {
            this.vertices[1] = iVertex2;
        } else {
            IOut.err(" no such vertex on this edge");
        }
    }

    public IVertex getOtherVertex(IVertex iVertex) {
        if (this.vertices[0] == iVertex) {
            return this.vertices[1];
        }
        if (this.vertices[1] == iVertex) {
            return this.vertices[0];
        }
        IOut.err("no such vertex on this edge");
        return null;
    }

    public IVertex getOtherVertex(IEdge iEdge) {
        if (iEdge.contains(this.vertices[0])) {
            return this.vertices[1];
        }
        if (iEdge.contains(this.vertices[1])) {
            return this.vertices[0];
        }
        return null;
    }

    public IVertex getSharedVertex(IEdge iEdge) {
        if (iEdge.contains(this.vertices[0])) {
            return this.vertices[0];
        }
        if (iEdge.contains(this.vertices[1])) {
            return this.vertices[1];
        }
        return null;
    }

    public IFace sharedFace(IEdge iEdge) {
        int n;
        for (n = 0; n < this.faces.size(); ++n) {
            for (int i = 0; i < iEdge.faceNum(); ++i) {
                if (!this.faces.get(n).eq(iEdge.face(i))) continue;
                return this.faces.get(n);
            }
        }
        for (n = 0; n < this.faces.size(); ++n) {
            if (!this.faces.get(n).onFace(iEdge)) continue;
            return this.faces.get(n);
        }
        return null;
    }

    public IEdge getOverlappingEdge() {
        for (int i = 0; i < this.vertices[0].edgeNum(); ++i) {
            if (this.vertices[0].edge(i) == this || this.vertices[0].edge(i).getOtherVertex(this.vertices[0]) != this.vertices[1]) continue;
            return this.vertices[0].edge(i);
        }
        return null;
    }

    public IEdge[] getOverlappingEdges() {
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (int i = 0; i < this.vertices[0].edgeNum(); ++i) {
            if (this.vertices[0].edge(i) == this || this.vertices[0].edge(i).getOtherVertex(this.vertices[0]) != this.vertices[1]) continue;
            arrayList.add(this.vertices[0].edge(i));
        }
        return arrayList.toArray(new IEdge[arrayList.size()]);
    }

    public boolean hasSharedVertex(IEdge iEdge) {
        return this.getSharedVertex(iEdge) != null;
    }

    public boolean isConnected(IEdge iEdge) {
        return this.hasSharedVertex(iEdge);
    }

    public IFace getOtherFace(IFace iFace) {
        for (int i = 0; i < this.faces.size(); ++i) {
            if (this.faces.get(i) == iFace) continue;
            return this.faces.get(i);
        }
        IEdge[] iEdgeArray = this.getOverlappingEdges();
        for (int i = 0; i < iEdgeArray.length; ++i) {
            for (int j = 0; j < iEdgeArray[i].faceNum(); ++j) {
                if (iEdgeArray[i].face(j) == iFace) continue;
                return iEdgeArray[i].face(j);
            }
        }
        return null;
    }

    public IFace[] getOtherFaces(IFace iFace) {
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < this.faces.size(); ++i) {
            if (this.faces.get(i) == iFace) continue;
            arrayList.add(this.faces.get(i));
        }
        IEdge[] iEdgeArray = this.getOverlappingEdges();
        for (int i = 0; i < iEdgeArray.length; ++i) {
            for (int j = 0; j < iEdgeArray[i].faceNum(); ++j) {
                if (iEdgeArray[i].face(j) == iFace) continue;
                arrayList.add(iEdgeArray[i].face(j));
            }
        }
        return arrayList.toArray(new IFace[arrayList.size()]);
    }

    public boolean isOnEdge(IVertex iVertex) {
        IVec iVec;
        IVec iVec2 = this.vertices[1].pos.get().diff(this.vertices[0].pos);
        if (!iVec2.isParallel(iVec = iVertex.pos.get().diff(this.vertices[0].pos))) {
            return false;
        }
        double d = iVec2.dot(iVec);
        return !(d < 0.0) && !(d > iVec2.len2());
    }

    public ArrayList<ArrayList<IEdge>> traceEdge(int n) {
        ArrayList<ArrayList<IEdge>> arrayList = new ArrayList<ArrayList<IEdge>>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        this.traceEdge(arrayList2, arrayList, n);
        return arrayList;
    }

    public void traceEdge(ArrayList<IEdge> arrayList, ArrayList<ArrayList<IEdge>> arrayList2, int n) {
        IVertex iVertex = null;
        if (arrayList.size() > 0) {
            iVertex = this.getOtherVertex(arrayList.get(arrayList.size() - 1));
            if (iVertex == null) {
                // empty if block
            }
        } else {
            iVertex = this.vertices[1];
        }
        if (arrayList.size() > 1 && arrayList.get((int)0).vertices[0] == iVertex) {
            ArrayList<IEdge> arrayList3 = new ArrayList<IEdge>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList3.add(arrayList.get(i));
            }
            arrayList3.add(this);
            arrayList2.add(arrayList3);
            return;
        }
        if (n <= 1) {
            return;
        }
        arrayList.add(this);
        if (iVertex != null) {
            for (int i = 0; i < iVertex.edges.size(); ++i) {
                if (iVertex.edges.get(i) == this) continue;
                iVertex.edges.get(i).traceEdge(arrayList, arrayList2, n - 1);
            }
        }
        arrayList.remove(arrayList.size() - 1);
    }

    public String toString() {
        if (this.vertices == null) {
            return super.toString();
        }
        String string = "null";
        if (this.vertices[0] != null) {
            string = this.vertices[0].toString();
        }
        String string2 = "null";
        if (this.vertices[1] != null) {
            string2 = this.vertices[1].toString();
        }
        return "IEdge: " + string + "-" + string2;
    }

    public boolean eq(IEdge iEdge) {
        return this.eq(iEdge, IConfig.tolerance);
    }

    public boolean eq(IEdge iEdge, double d) {
        if (this.vertices.length != iEdge.vertices.length) {
            return false;
        }
        if (this.vertices[0] == iEdge.vertices[0] && this.vertices[1] == iEdge.vertices[1]) {
            return true;
        }
        if (this.vertices[0] == iEdge.vertices[1] && this.vertices[1] == iEdge.vertices[0]) {
            return true;
        }
        if (this.vertices[0].eq(iEdge.vertices[0], d) && this.vertices[1].eq(iEdge.vertices[1], d)) {
            return true;
        }
        return this.vertices[0].eq(iEdge.vertices[1], d) && this.vertices[1].eq(iEdge.vertices[0], d);
    }

    public IFace[] createFace(IMeshType iMeshType) {
        ArrayList<ArrayList<IEdge>> arrayList = this.traceEdge(iMeshType.getMaxVertexNum());
        if (arrayList.size() == 0) {
            return null;
        }
        IFace[] iFaceArray = new IFace[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            IEdge[] iEdgeArray = arrayList.get(i).toArray(new IEdge[arrayList.get(i).size()]);
            iFaceArray[i] = iMeshType.createFace(iEdgeArray);
        }
        return iFaceArray;
    }

    public IVertex[] subdivide(int n, ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2) {
        int n2;
        IEdge[] iEdgeArray = new IEdge[n];
        IVertex[] iVertexArray = new IVertex[n + 1];
        for (n2 = 0; n2 <= n; ++n2) {
            iVertexArray[n2] = n2 == 0 ? this.vertices[0] : (n2 == n ? this.vertices[1] : new IVertex(this.vertices[0].pos.sum(this.vertices[1].pos, (double)n2 / (double)n)));
            if (n2 <= 0) continue;
            iEdgeArray[n2 - 1] = new IEdge(iVertexArray[n2 - 1], iVertexArray[n2]);
        }
        this.del();
        for (n2 = 0; n2 < iVertexArray.length; ++n2) {
            arrayList.add(iVertexArray[n2]);
        }
        for (n2 = 0; n2 < iEdgeArray.length; ++n2) {
            arrayList2.add(iEdgeArray[n2]);
        }
        return iVertexArray;
    }
}

