/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ISurfaceGeo;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.gui.IPolyline2D;
import igeo.gui.ITrimLoopGraphic;

public class ITrimCache {
    public ISurfaceGeo surface;
    public int resolution;
    public int udeg;
    public int vdeg;
    public IPolyline2D[] outTrims;
    public IPolyline2D[] inTrims;

    public ITrimCache(ISurfaceGeo iSurfaceGeo, int n) {
        this.surface = iSurfaceGeo;
        this.resolution = n;
        this.init();
    }

    public ITrimCache(ISurfaceGeo iSurfaceGeo) {
        this(iSurfaceGeo, IConfig.segmentResolution);
    }

    public void init() {
        ITrimLoopGraphic iTrimLoopGraphic;
        int n;
        if (this.surface.hasOuterTrim()) {
            this.outTrims = new IPolyline2D[this.surface.outerTrimLoopNum()];
            for (n = 0; n < this.surface.outerTrimLoopNum(); ++n) {
                iTrimLoopGraphic = new ITrimLoopGraphic(this.surface.outerTrimLoop(n), true, this.resolution);
                this.outTrims[n] = iTrimLoopGraphic.getPolyline2D();
            }
        }
        if (this.surface.hasInnerTrim()) {
            this.inTrims = new IPolyline2D[this.surface.innerTrimLoopNum()];
            for (n = 0; n < this.surface.innerTrimLoopNum(); ++n) {
                iTrimLoopGraphic = new ITrimLoopGraphic(this.surface.innerTrimLoop(n), true, this.resolution);
                this.inTrims[n] = iTrimLoopGraphic.getPolyline2D();
            }
        }
    }

    public boolean isInside(IVec2I iVec2I) {
        return this.isInside(iVec2I.get());
    }

    public boolean isInside(double d, double d2) {
        return this.isInside(new IVec2(d, d2));
    }

    public boolean isInside(IVec2 iVec2) {
        int n;
        if (this.inTrims != null) {
            for (n = 0; n < this.inTrims.length; ++n) {
                if (!iVec2.isInside(this.inTrims[n].get())) continue;
                return false;
            }
        }
        if (this.outTrims != null) {
            for (n = 0; n < this.outTrims.length; ++n) {
                if (!iVec2.isInside(this.outTrims[n].get())) continue;
                return true;
            }
            if (this.outTrims.length > 0) {
                return false;
            }
        }
        return !(iVec2.x < 0.0 || iVec2.x > 1.0 || iVec2.y < 0.0) && !(iVec2.y > 1.0);
    }
}

