/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.ICurveR;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class ICurveGraphicGL
extends IGraphicObject {
    public float weight = IConfig.strokeWeight;
    public ICurveI curve;
    public IVec[] pts;

    public ICurveGraphicGL(ICurve iCurve) {
        super(iCurve);
    }

    public ICurveGraphicGL(ICurveR iCurveR) {
        super(iCurveR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initCurve() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            if (this.curve == null) {
                if (this.parent instanceof ICurve) {
                    this.curve = ((ICurve)this.parent).curve;
                } else if (this.parent instanceof ICurveR) {
                    this.curve = ((ICurveR)this.parent).curve;
                }
            }
            if (this.curve.deg() == 1) {
                int n = this.curve.num();
                if (this.pts == null || this.pts.length != n) {
                    this.pts = new IVec[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.pts[i] = this.curve.cp(i).get();
                }
            } else {
                int n = IConfig.segmentResolution;
                int n2 = this.curve.epNum();
                int n3 = (n2 - 1) * n + 1;
                if (this.pts == null || this.pts.length != n3) {
                    this.pts = new IVec[n3];
                }
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (i >= n2 - 1 && j != 0) continue;
                        this.pts[i * n + j] = this.curve.pt(this.curve.u(i, (double)j / (double)n)).get();
                    }
                }
            }
            if (this.update) {
                this.update = false;
            }
        }
    }

    @Override
    public void setWeight(float f) {
        this.weight = f;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    @Override
    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }

    @Override
    public synchronized void draw(IGraphics iGraphics) {
        if (this.curve == null || this.update) {
            this.initCurve();
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            iGraphics3D.weight(this.weight);
            float[] fArray = null;
            fArray = this.color != null ? this.color.rgba() : IConfig.objectColor.rgba();
            if (iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe()) {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], (float)IConfig.transparentModeAlpha / 255.0f};
            }
            if (iGraphics3D.view().mode().isLight() && iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(fArray);
                iGraphics3D.diffuse(fArray);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.stroke(fArray[0] * 255.0f, fArray[1] * 255.0f, fArray[2] * 255.0f, 0.0f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            iGraphics3D.stroke(fArray);
            if (this.pts.length == 2) {
                iGraphics3D.drawLineStrip(this.pts);
            } else {
                iGraphics3D.drawLineStrip(this.pts);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        }
    }
}

