/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IDynamics;
import igeo.IObject;
import igeo.IOut;
import igeo.IServer;
import igeo.IServerI;
import java.util.ArrayList;

public class IDynamicServer
implements Runnable {
    public Thread thread;
    public IServer server;
    public boolean runningDynamics = false;
    public boolean startedOnce = false;
    public ArrayList<IDynamics> dynamics;
    public ArrayList<IDynamics> addingDynamics;
    public ArrayList<IDynamics> removingDynamics;
    public int duration = -1;
    public int time;
    public boolean showTime = false;

    public IDynamicServer(IServerI iServerI) {
        this.server = iServerI.server();
        this.dynamics = new ArrayList();
        this.addingDynamics = new ArrayList();
        this.removingDynamics = new ArrayList();
    }

    public synchronized void add(IObject iObject) {
        for (IDynamics iDynamics : iObject.dynamics) {
            this.add(iDynamics);
        }
    }

    public synchronized void add(IDynamics iDynamics) {
        if (!this.runningDynamics) {
            if (!this.dynamics.contains(iDynamics)) {
                this.dynamics.add(iDynamics);
            }
        } else if (!this.addingDynamics.contains(iDynamics) && !this.dynamics.contains(iDynamics)) {
            this.addingDynamics.add(iDynamics);
            if (this.removingDynamics.contains(iDynamics)) {
                this.removingDynamics.remove(iDynamics);
            }
        }
    }

    public int addingNum() {
        return this.addingDynamics.size();
    }

    public int removingNum() {
        return this.removingDynamics.size();
    }

    public int num() {
        return this.dynamics.size();
    }

    public IDynamics get(int n) {
        return this.dynamics.get(n);
    }

    public synchronized void remove(int n) {
        IDynamics iDynamics = this.dynamics.get(n);
        if (!this.removingDynamics.contains(iDynamics)) {
            this.removingDynamics.add(iDynamics);
            if (this.addingDynamics.contains(iDynamics)) {
                this.addingDynamics.remove(iDynamics);
            }
        }
    }

    public synchronized void remove(IDynamics iDynamics) {
        if (!this.removingDynamics.contains(iDynamics)) {
            this.removingDynamics.add(iDynamics);
            if (this.addingDynamics.contains(iDynamics)) {
                this.addingDynamics.remove(iDynamics);
            }
        }
    }

    public synchronized void clear() {
        this.addingDynamics.clear();
        this.removingDynamics.clear();
        this.dynamics.clear();
    }

    public IDynamicServer duration(int n) {
        this.duration = n;
        return this;
    }

    public int duration() {
        return this.duration;
    }

    public IDynamicServer time(int n) {
        this.time = n;
        return this;
    }

    public int time() {
        return this.time;
    }

    public IDynamicServer showTime(boolean bl) {
        this.showTime = bl;
        return this;
    }

    public void pause() {
        this.runningDynamics = false;
    }

    public void resume() {
        this.runningDynamics = true;
    }

    public boolean isRunning() {
        return this.runningDynamics;
    }

    public void start() {
        if (!this.startedOnce && !this.runningDynamics && this.thread == null) {
            this.thread = new Thread(this);
            this.runningDynamics = true;
            this.startedOnce = true;
            this.time = 0;
            this.thread.start();
            IOut.debug(0, "dynamic server started");
        }
    }

    public void startWithoutThread() {
        this.runningDynamics = true;
        this.startedOnce = true;
        this.time = 0;
        IOut.debug(0, "dynamic server started");
    }

    public void stop() {
        if (this.runningDynamics || this.thread != null) {
            this.runningDynamics = false;
            this.thread = null;
            IOut.debug(0, "dynamic server stopped");
        }
    }

    public void reset() {
        this.startedOnce = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step() {
        if (this.runningDynamics) {
            if (this.duration >= 0 && this.time >= this.duration) {
                this.stop();
            } else {
                IDynamicServer iDynamicServer = this;
                synchronized (iDynamicServer) {
                    int n;
                    ArrayList<IDynamics> arrayList;
                    int n2;
                    if (this.addingDynamics.size() > 0) {
                        this.dynamics.addAll(this.addingDynamics);
                        this.addingDynamics.clear();
                    }
                    if (this.removingDynamics.size() > 0) {
                        this.dynamics.removeAll(this.removingDynamics);
                        this.removingDynamics.clear();
                    }
                    if (IConfig.loopPreinteract && IConfig.enablePreinteract) {
                        for (n2 = 0; n2 < this.dynamics.size(); ++n2) {
                            this.dynamics.get(n2).preinteract(this.dynamics);
                            if (this.dynamics.get(n2).localDynamics() == null) continue;
                            arrayList = this.dynamics.get(n2).localDynamics();
                            for (n = 0; n < arrayList.size(); ++n) {
                                arrayList.get(n).preinteract(this.dynamics);
                            }
                        }
                    }
                    for (n2 = 0; n2 < this.dynamics.size(); ++n2) {
                        if (!IConfig.loopPreinteract && IConfig.enablePreinteract) {
                            this.dynamics.get(n2).preinteract(this.dynamics);
                            if (this.dynamics.get(n2).localDynamics() != null) {
                                arrayList = this.dynamics.get(n2).localDynamics();
                                for (n = 0; n < arrayList.size(); ++n) {
                                    arrayList.get(n).preinteract(this.dynamics);
                                }
                            }
                        }
                        this.dynamics.get(n2).interact(this.dynamics);
                        if (this.dynamics.get(n2).localDynamics() != null) {
                            arrayList = this.dynamics.get(n2).localDynamics();
                            for (n = 0; n < arrayList.size(); ++n) {
                                arrayList.get(n).interact(this.dynamics);
                            }
                        }
                        if (IConfig.loopPostinteract || !IConfig.enablePostinteract) continue;
                        this.dynamics.get(n2).postinteract(this.dynamics);
                        if (this.dynamics.get(n2).localDynamics() == null) continue;
                        arrayList = this.dynamics.get(n2).localDynamics();
                        for (n = 0; n < arrayList.size(); ++n) {
                            arrayList.get(n).postinteract(this.dynamics);
                        }
                    }
                    if (IConfig.loopPreupdate && IConfig.enablePreupdate) {
                        for (n2 = 0; n2 < this.dynamics.size(); ++n2) {
                            this.dynamics.get(n2).preupdate();
                            if (this.dynamics.get(n2).localDynamics() == null) continue;
                            arrayList = this.dynamics.get(n2).localDynamics();
                            for (n = 0; n < arrayList.size(); ++n) {
                                arrayList.get(n).preupdate();
                            }
                        }
                    }
                    if (IConfig.loopPostinteract && IConfig.enablePostinteract) {
                        for (n2 = 0; n2 < this.dynamics.size(); ++n2) {
                            this.dynamics.get(n2).postinteract(this.dynamics);
                            if (this.dynamics.get(n2).localDynamics() == null) continue;
                            arrayList = this.dynamics.get(n2).localDynamics();
                            for (n = 0; n < arrayList.size(); ++n) {
                                arrayList.get(n).postinteract(this.dynamics);
                            }
                        }
                    }
                    if (this.removingDynamics.size() > 0) {
                        this.dynamics.removeAll(this.removingDynamics);
                        this.removingDynamics.clear();
                    }
                    for (n2 = 0; n2 < this.dynamics.size(); ++n2) {
                        if (!IConfig.loopPreupdate && IConfig.enablePreupdate) {
                            this.dynamics.get(n2).preupdate();
                            if (this.dynamics.get(n2).localDynamics() != null) {
                                arrayList = this.dynamics.get(n2).localDynamics();
                                for (n = 0; n < arrayList.size(); ++n) {
                                    arrayList.get(n).preupdate();
                                }
                            }
                        }
                        this.dynamics.get(n2).update();
                        if (this.dynamics.get(n2).localDynamics() != null) {
                            arrayList = this.dynamics.get(n2).localDynamics();
                            for (n = 0; n < arrayList.size(); ++n) {
                                arrayList.get(n).update();
                            }
                        }
                        if (IConfig.loopPostupdate || !IConfig.enablePostupdate) continue;
                        this.dynamics.get(n2).postupdate();
                        if (this.dynamics.get(n2).localDynamics() == null) continue;
                        arrayList = this.dynamics.get(n2).localDynamics();
                        for (n = 0; n < arrayList.size(); ++n) {
                            arrayList.get(n).postupdate();
                        }
                    }
                    if (IConfig.loopPostupdate && IConfig.enablePostupdate) {
                        for (n2 = 0; n2 < this.dynamics.size(); ++n2) {
                            this.dynamics.get(n2).postupdate();
                            if (this.dynamics.get(n2).localDynamics() == null) continue;
                            arrayList = this.dynamics.get(n2).localDynamics();
                            for (n = 0; n < arrayList.size(); ++n) {
                                arrayList.get(n).postupdate();
                            }
                        }
                    }
                }
                ++this.time;
                if (IOut.debugLevel() >= 20 || IOut.debugLevel() < 0 || this.showTime) {
                    IOut.debug(0, "time=" + this.time);
                }
            }
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread) {
            this.step();
            try {
                Thread.sleep((int)(IConfig.updateRate * 1000.0));
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

