/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IG;
import igeo.IInteger;
import igeo.IIntegerI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IMeshI;
import igeo.IMeshType;
import igeo.IOut;
import igeo.IParameterObject;
import igeo.ISort;
import igeo.ISurfaceI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.util.ArrayList;

public class IMeshGeo
extends IParameterObject
implements IMeshI {
    public ArrayList<IVertex> vertices;
    public ArrayList<IEdge> edges;
    public ArrayList<IFace> faces;
    public boolean closed = false;

    public IMeshGeo(ICurveI[] iCurveIArray) {
        this.initWithLines(iCurveIArray, new IMeshType());
    }

    public IMeshGeo(ICurveI[] iCurveIArray, IMeshType iMeshType) {
        this.initWithLines(iCurveIArray, iMeshType);
    }

    public IMeshGeo(ISurfaceI[] iSurfaceIArray) {
        this.initWithSurfaces(iSurfaceIArray, new IMeshType());
    }

    public IMeshGeo(ISurfaceI[] iSurfaceIArray, IMeshType iMeshType) {
        this.initWithSurfaces(iSurfaceIArray, iMeshType);
    }

    public IMeshGeo(IVec[][] iVecArray) {
        this(iVecArray, true, new IMeshType());
    }

    public IMeshGeo(IVec[][] iVecArray, boolean bl) {
        this(iVecArray, bl, new IMeshType());
    }

    public IMeshGeo(IVec[][] iVecArray, boolean bl, IMeshType iMeshType) {
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.edges = new ArrayList();
        this.initWithPointMatrix(iVecArray, iVecArray.length, iVecArray[0].length, bl, iMeshType);
    }

    public IMeshGeo(IVec[][] iVecArray, int n, int n2, boolean bl) {
        this(iVecArray, n, n2, bl, new IMeshType());
    }

    public IMeshGeo(IVec[][] iVecArray, int n, int n2, boolean bl, IMeshType iMeshType) {
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.edges = new ArrayList();
        this.initWithPointMatrix(iVecArray, n, n2, bl, iMeshType);
    }

    public IMeshGeo() {
        this.vertices = new ArrayList();
        this.faces = new ArrayList();
        this.edges = new ArrayList();
    }

    public IMeshGeo(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        this.vertices = arrayList;
        this.edges = arrayList2;
        this.faces = arrayList3;
    }

    public IMeshGeo(IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iVertexArray.length; ++n) {
            this.addVertex(iVertexArray[n]);
        }
        for (n = 0; n < iEdgeArray.length; ++n) {
            this.edges.add(iEdgeArray[n]);
        }
        for (n = 0; n < iFaceArray.length; ++n) {
            this.faces.add(iFaceArray[n]);
        }
    }

    public IMeshGeo(IVec[] iVecArray) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iVecArray.length; ++n) {
            this.addVertex(new IVertex(iVecArray[n]));
        }
        for (n = 0; n < iVecArray.length; ++n) {
            this.edges.add(new IEdge(this.vertices.get(n), this.vertices.get((n + 1) % this.vertices.size())));
        }
        IEdge[] iEdgeArray = new IEdge[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            iEdgeArray[i] = this.edges.get(i);
        }
        this.faces.add(new IFace(iEdgeArray));
    }

    public IMeshGeo(IVertex[] iVertexArray) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iVertexArray.length; ++n) {
            this.addVertex(iVertexArray[n]);
        }
        for (n = 0; n < iVertexArray.length; ++n) {
            this.edges.add(new IEdge(this.vertices.get(n), this.vertices.get((n + 1) % this.vertices.size())));
        }
        IEdge[] iEdgeArray = new IEdge[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            iEdgeArray[i] = this.edges.get(i);
        }
        this.faces.add(new IFace(iEdgeArray));
    }

    public IMeshGeo(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        this(new IVertex[]{iVertex, iVertex2, iVertex3});
    }

    public IMeshGeo(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        this(new IVertex[]{iVertex, iVertex2, iVertex3, iVertex4});
    }

    public IMeshGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this(new IVertex[]{new IVertex(iVecI), new IVertex(iVecI2), new IVertex(iVecI3)});
    }

    public IMeshGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this(new IVertex[]{new IVertex(iVecI), new IVertex(iVecI2), new IVertex(iVecI3), new IVertex(iVecI4)});
    }

    public IMeshGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this(new IVertex[]{new IVertex(d, d2, d3), new IVertex(d4, d5, d6), new IVertex(d7, d8, d9)});
    }

    public IMeshGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this(new IVertex[]{new IVertex(d, d2, d3), new IVertex(d4, d5, d6), new IVertex(d7, d8, d9), new IVertex(d10, d11, d12)});
    }

    public IMeshGeo(IFace[] iFaceArray) {
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (IFace iFace : iFaceArray) {
            this.faces.add(iFace);
            for (IVertex iVertex : iFace.vertices) {
                if (this.vertices.contains(iVertex)) continue;
                this.addVertex(iVertex);
            }
            for (IEdge iEdge : iFace.edges) {
                if (this.edges.contains(iEdge)) continue;
                this.edges.add(iEdge);
            }
        }
        if (IConfig.removeDuplicatesAtMeshCreation) {
            this.removeDuplicates();
        }
    }

    public IMeshGeo(IMeshGeo iMeshGeo) {
        int n;
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (n = 0; n < iMeshGeo.vertices.size(); ++n) {
            this.addVertex(iMeshGeo.vertices.get(n).dup());
        }
        for (n = 0; n < iMeshGeo.edges.size(); ++n) {
            this.edges.add(iMeshGeo.edges.get(n).dup());
        }
        for (n = 0; n < iMeshGeo.faces.size(); ++n) {
            this.faces.add(iMeshGeo.faces.get(n).dup());
        }
        for (n = 0; n < iMeshGeo.faces.size(); ++n) {
            this.replaceFace(iMeshGeo.faces.get(n), this.faces.get(n));
        }
        for (n = 0; n < iMeshGeo.edges.size(); ++n) {
            this.replaceEdge(iMeshGeo.edges.get(n), this.edges.get(n));
        }
        for (n = 0; n < iMeshGeo.vertices.size(); ++n) {
            this.replaceVertex(iMeshGeo.vertices.get(n), this.vertices.get(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWithLines(ICurveI[] iCurveIArray, IMeshType iMeshType) {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        for (n = 0; n < iCurveIArray.length; ++n) {
            if (!iCurveIArray[n].isClosed()) continue;
            ++n2;
        }
        if (n2 > iCurveIArray.length / 2) {
            this.initWithClosedLines(iCurveIArray, iMeshType);
            return;
        }
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        for (n = 0; n < iCurveIArray.length; ++n) {
            object2 = iCurveIArray[n];
            IVertex iVertex = iMeshType.createVertex(object2.start().get());
            IVertex iVertex2 = iMeshType.createVertex(object2.end().get());
            object = iMeshType.createEdge(iVertex, iVertex2);
            this.edges.add((IEdge)object);
            this.vertices.add(iVertex);
            this.vertices.add(iVertex2);
        }
        ISort.sort(this.vertices, new IVertex.ZYXComparator());
        for (n = 0; n < this.vertices.size(); ++n) {
            object2 = this.vertices.get(n);
            boolean bl = true;
            for (int i = n + 1; i < this.vertices.size() && bl; ++i) {
                object = this.vertices.get(i);
                if (((IVertex)object2).eq((IVecI)object)) {
                    Object object3 = IG.lock;
                    synchronized (object3) {
                        ((IVertex)object).replaceVertex((IVertex)object2);
                        this.vertices.remove(i);
                        --i;
                        continue;
                    }
                }
                bl = false;
            }
        }
        for (n = this.vertices.size() - 1; n >= 0; --n) {
            if (this.vertices.get((int)n).edges.size() != 0) continue;
            this.vertices.remove(n);
        }
        this.faces = new ArrayList();
        for (n = 0; n < this.edges.size(); ++n) {
            object2 = this.edges.get(n);
            IFace[] iFaceArray = ((IEdge)object2).createFace(iMeshType);
            if (iFaceArray == null) continue;
            for (int i = 0; i < iFaceArray.length; ++i) {
                object = IG.lock;
                synchronized (object) {
                    boolean bl = true;
                    for (int j = 0; j < this.faces.size() && bl; ++j) {
                        IFace iFace = this.faces.get(j);
                        if (iFace != iFaceArray[i]) continue;
                        bl = false;
                    }
                    if (bl) {
                        this.faces.add(iFaceArray[i]);
                    } else {
                        iFaceArray[i].del();
                    }
                    continue;
                }
            }
        }
    }

    public void initWithClosedLines(ICurveI[] iCurveIArray, IMeshType iMeshType) {
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iCurveIArray.length; ++i) {
            if (iCurveIArray[i].deg() != 1 || !iCurveIArray[i].isClosed()) continue;
            IVecI[] iVecIArray = new IVecI[iCurveIArray[i].cpNum() - 1];
            for (int j = 0; j < iCurveIArray[i].cpNum() - 1; ++j) {
                iVecIArray[j] = iCurveIArray[i].cp(j);
            }
            arrayList.add(iVecIArray);
        }
        this.initWithClosedLines((IVecI[][])arrayList.toArray((T[])new IVecI[arrayList.size()][]), iMeshType);
    }

    public void initWithClosedLines(IVecI[][] iVecIArray, IMeshType iMeshType) {
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        for (int i = 0; i < iVecIArray.length; ++i) {
            int n;
            boolean bl;
            Object object;
            int n2 = iVecIArray[i].length;
            IVertex[] iVertexArray = new IVertex[n2];
            for (int j = 0; j < n2; ++j) {
                object = iVecIArray[i][j];
                bl = true;
                for (n = 0; n < this.vertices.size() && bl; ++n) {
                    if (!object.eq(this.vertices.get(n))) continue;
                    bl = false;
                    iVertexArray[j] = this.vertices.get(n);
                }
                if (!bl) continue;
                iVertexArray[j] = iMeshType.createVertex((IVecI)object);
                this.addVertex(iVertexArray[j]);
            }
            IEdge[] iEdgeArray = new IEdge[n2];
            for (int j = 0; j < n2; ++j) {
                bl = true;
                for (n = 0; n < this.edges.size() && bl; ++n) {
                    if (!this.edges.get(i).contains(iVertexArray[j], iVertexArray[(j + 1) % n2])) continue;
                    bl = false;
                    iEdgeArray[j] = this.edges.get(i);
                }
                if (!bl) continue;
                iEdgeArray[j] = iMeshType.createEdge(iVertexArray[j], iVertexArray[(j + 1) % n2]);
                this.edges.add(iEdgeArray[j]);
            }
            object = iMeshType.createFace(iEdgeArray);
            this.faces.add((IFace)object);
        }
    }

    public void initWithSurfaces(ISurfaceI[] iSurfaceIArray, IMeshType iMeshType) {
        ArrayList<IVecI[]> arrayList = new ArrayList<IVecI[]>();
        for (int i = 0; i < iSurfaceIArray.length; ++i) {
            ArrayList<IVecI> arrayList2 = new ArrayList<IVecI>();
            arrayList2.add(iSurfaceIArray[i].cornerCP(0, 0));
            if (!((IVecI)arrayList2.get(arrayList2.size() - 1)).eq(iSurfaceIArray[i].cornerCP(1, 0))) {
                arrayList2.add(iSurfaceIArray[i].cornerCP(1, 0));
            }
            if (!((IVecI)arrayList2.get(arrayList2.size() - 1)).eq(iSurfaceIArray[i].cornerCP(1, 1))) {
                arrayList2.add(iSurfaceIArray[i].cornerCP(1, 1));
            }
            if (!((IVecI)arrayList2.get(arrayList2.size() - 1)).eq(iSurfaceIArray[i].cornerCP(0, 1))) {
                arrayList2.add(iSurfaceIArray[i].cornerCP(0, 1));
            }
            if (arrayList2.size() != 3 && arrayList2.size() != 4) continue;
            arrayList.add(arrayList2.toArray(new IVecI[arrayList2.size()]));
        }
        this.initWithClosedLines((IVecI[][])arrayList.toArray((T[])new IVecI[arrayList.size()][]), iMeshType);
    }

    @Override
    public IMeshGeo get() {
        return this;
    }

    @Override
    public IMeshGeo dup() {
        return new IMeshGeo(this);
    }

    @Override
    public boolean isValid() {
        if (this.vertices == null) {
            return false;
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.vertices.get(i).isValid()) continue;
            IOut.err("vertices at " + i + " is invalid");
            return false;
        }
        return true;
    }

    public void addVertex(IVertex iVertex) {
        this.vertices.add(iVertex);
    }

    protected void replaceVertex(IVertex iVertex, IVertex iVertex2) {
        int n;
        for (IVertex object : this.vertices) {
            for (n = 0; n < object.linkedVertices.size(); ++n) {
                if (object.linkedVertices.get(n) != iVertex) continue;
                object.linkedVertices.set(n, iVertex2);
            }
        }
        for (IEdge iEdge : this.edges) {
            for (n = 0; n < iEdge.vertices.length; ++n) {
                if (iEdge.vertices[n] != iVertex) continue;
                iEdge.vertices[n] = iVertex2;
            }
        }
        for (IFace iFace : this.faces) {
            for (n = 0; n < iFace.vertices.length; ++n) {
                if (iFace.vertices[n] != iVertex) continue;
                iFace.vertices[n] = iVertex2;
            }
        }
    }

    protected void replaceEdge(IEdge iEdge, IEdge iEdge2) {
        int n;
        for (IVertex object : this.vertices) {
            for (n = 0; n < object.edges.size(); ++n) {
                if (object.edges.get(n) != iEdge) continue;
                object.edges.set(n, iEdge2);
            }
        }
        for (IFace iFace : this.faces) {
            for (n = 0; n < iFace.edges.length; ++n) {
                if (iFace.edges[n] != iEdge) continue;
                iFace.edges[n] = iEdge2;
            }
        }
    }

    protected void replaceFace(IFace iFace, IFace iFace2) {
        int n;
        for (IVertex object : this.vertices) {
            for (n = 0; n < object.faces.size(); ++n) {
                if (object.faces.get(n) != iFace) continue;
                object.faces.set(n, iFace2);
            }
        }
        for (IEdge iEdge : this.edges) {
            for (n = 0; n < iEdge.faces.size(); ++n) {
                if (iEdge.faces.get(n) != iFace) continue;
                iEdge.faces.set(n, iFace2);
            }
        }
    }

    public static IMeshGeo createMeshWithEdges(ArrayList<IEdge> arrayList, IMeshType iMeshType) {
        IMeshGeo iMeshGeo = new IMeshGeo();
        iMeshGeo.initWithEdges(arrayList, iMeshType);
        return iMeshGeo;
    }

    public static IMeshGeo createPolyhedron(IVertex[] iVertexArray) {
        int n;
        int n2 = iVertexArray.length;
        IVec iVec = new IVec();
        IVec[] iVecArray = new IVec[n2];
        for (n = 0; n < n2; ++n) {
            iVecArray[n] = iVertexArray[n].get().dup();
            iVec.add(iVecArray[n]);
        }
        iVec.div(n2);
        for (n = 0; n < n2; ++n) {
            iVecArray[n].sub(iVec).unit();
        }
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < n2; ++i) {
            if (i % 10 == 0) {
                IOut.debug(20, "checking vertex " + i + "/" + n2);
            }
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    boolean bl = false;
                    IVec iVec2 = IVec.circumcenter(iVecArray[i], iVecArray[j], iVecArray[k]);
                    if (iVec2 == null) {
                        bl = true;
                    } else {
                        double d = iVec2.dist(iVecArray[i]);
                        for (int i2 = 0; i2 < n2 && !bl; ++i2) {
                            IVec iVec3;
                            if (i == i2 || j == i2 || k == i2 || (iVec3 = IVec.intersectPlaneAndLine(iVecArray[i], iVecArray[j], iVecArray[k], iVecArray[i2], IG.origin)) == null || !(iVec3.dot(iVecArray[i2]) > 0.0) || !(d > iVec2.dist(iVec3))) continue;
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    if (iVecArray[i].nml(iVecArray[j], iVecArray[k]).dot(iVecArray[i]) > 0.0) {
                        arrayList.add(new IFace(iVertexArray[i], iVertexArray[j], iVertexArray[k]));
                        continue;
                    }
                    arrayList.add(new IFace(iVertexArray[i], iVertexArray[k], iVertexArray[j]));
                }
            }
        }
        return new IMeshGeo(arrayList.toArray(new IFace[arrayList.size()]));
    }

    public static IMeshGeo createPolyhedron(IVertex[] iVertexArray, double d) {
        int n;
        int n2 = iVertexArray.length;
        IVec iVec = new IVec();
        IVec[] iVecArray = new IVec[n2];
        for (n = 0; n < n2; ++n) {
            iVecArray[n] = iVertexArray[n].get().dup();
            iVec.add(iVecArray[n]);
        }
        iVec.div(n2);
        for (n = 0; n < n2; ++n) {
            iVecArray[n].sub(iVec).unit();
        }
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < n2; ++i) {
            if (i % 10 == 0) {
                IOut.debug(20, "checking vertex " + i + "/" + n2);
            }
            for (int j = i + 1; j < n2; ++j) {
                if (!(iVertexArray[j].pos.dist(iVertexArray[i].pos) < d)) continue;
                for (int k = j + 1; k < n2; ++k) {
                    if (!(iVertexArray[k].pos.dist(iVertexArray[i].pos) < d) || !(iVertexArray[k].pos.dist(iVertexArray[j].pos) < d)) continue;
                    boolean bl = false;
                    IVec iVec2 = IVec.circumcenter(iVecArray[i], iVecArray[j], iVecArray[k]);
                    if (iVec2 == null) {
                        bl = true;
                    } else {
                        double d2 = iVec2.dist(iVecArray[i]);
                        for (int i2 = 0; i2 < n2 && !bl; ++i2) {
                            IVec iVec3;
                            if (!(iVertexArray[i2].dist(iVertexArray[i]) < d) || !(iVertexArray[i2].dist(iVertexArray[j]) < d) || !(iVertexArray[i2].dist(iVertexArray[k]) < d) || i == i2 || j == i2 || k == i2 || (iVec3 = IVec.intersectPlaneAndLine(iVecArray[i], iVecArray[j], iVecArray[k], iVecArray[i2], IG.origin)) == null || !(iVec3.dot(iVecArray[i2]) > 0.0) || !(d2 > iVec2.dist(iVec3))) continue;
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    if (iVecArray[i].nml(iVecArray[j], iVecArray[k]).dot(iVecArray[i]) > 0.0) {
                        arrayList.add(new IFace(iVertexArray[i], iVertexArray[j], iVertexArray[k]));
                        continue;
                    }
                    arrayList.add(new IFace(iVertexArray[i], iVertexArray[k], iVertexArray[j]));
                }
            }
        }
        return new IMeshGeo(arrayList.toArray(new IFace[arrayList.size()]));
    }

    public static IMeshGeo polyhedron(IVertex[] iVertexArray) {
        return IMeshGeo.createPolyhedron(iVertexArray);
    }

    public static IMeshGeo polyhedron(IVertex[] iVertexArray, double d) {
        return IMeshGeo.createPolyhedron(iVertexArray, d);
    }

    public static IMeshGeo connectVertex(IMeshGeo iMeshGeo, IMeshGeo iMeshGeo2) {
        int n = iMeshGeo.vertexNum();
        int n2 = iMeshGeo2.vertexNum();
        double d = -1.0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = iMeshGeo.vertex(i).dist(iMeshGeo2.vertex(j));
                if (!(d < 0.0) && !(d2 < d)) continue;
                d = d2;
                n3 = i;
                n4 = j;
            }
        }
        return IMeshGeo.connectVertex(iMeshGeo, iMeshGeo.vertex(n3), iMeshGeo2, iMeshGeo2.vertex(n4));
    }

    public static IMeshGeo connectVertex(IMeshGeo iMeshGeo, IVertex iVertex, IMeshGeo iMeshGeo2, IVertex iVertex2) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IVertex> arrayList2 = new ArrayList<IVertex>();
        for (n4 = 0; n4 < iVertex.linkedVertices.size(); ++n4) {
            if (arrayList.contains(iVertex.linkedVertices.get(n4))) continue;
            arrayList.add(iVertex.linkedVertices.get(n4));
        }
        for (n4 = 0; n4 < iVertex2.linkedVertices.size(); ++n4) {
            if (arrayList2.contains(iVertex2.linkedVertices.get(n4))) continue;
            arrayList2.add(iVertex2.linkedVertices.get(n4));
        }
        ArrayList arrayList3 = new ArrayList();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            arrayList3.add(arrayList.get(n3));
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            arrayList3.add(arrayList2.get(n3));
        }
        IMeshGeo iMeshGeo3 = IMeshGeo.polyhedron(arrayList3.toArray(new IVertex[arrayList3.size()]));
        ArrayList<IFace> arrayList4 = new ArrayList<IFace>();
        for (n2 = 0; n2 < iMeshGeo3.faceNum(); ++n2) {
            bl = false;
            if (arrayList.contains(iMeshGeo3.face(n2).vertex(0))) {
                for (n = 1; n < iMeshGeo3.face(n2).vertexNum() && !bl; ++n) {
                    if (arrayList.contains(iMeshGeo3.face(n2).vertex(n))) continue;
                    bl = true;
                }
            } else {
                for (n = 1; n < iMeshGeo3.face(n2).vertexNum() && !bl; ++n) {
                    if (!arrayList.contains(iMeshGeo3.face(n2).vertex(n))) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            arrayList4.add(iMeshGeo3.face(n2));
        }
        for (n2 = 0; n2 < iMeshGeo.faceNum(); ++n2) {
            bl = false;
            for (n = 0; n < iMeshGeo.face(n2).vertexNum() && !bl; ++n) {
                if (iMeshGeo.face(n2).vertex(n) != iVertex) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList4.add(iMeshGeo.face(n2));
        }
        for (n2 = 0; n2 < iMeshGeo2.faceNum(); ++n2) {
            bl = false;
            for (n = 0; n < iMeshGeo2.face(n2).vertexNum() && !bl; ++n) {
                if (iMeshGeo2.face(n2).vertex(n) != iVertex2) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList4.add(iMeshGeo2.face(n2));
        }
        return new IMeshGeo(arrayList4.toArray(new IFace[arrayList4.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWithEdges(ArrayList<IEdge> arrayList, IMeshType iMeshType) {
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!this.vertices.contains(arrayList.get((int)n).vertices[0])) {
                this.addVertex(arrayList.get((int)n).vertices[0]);
            }
            if (this.vertices.contains(arrayList.get((int)n).vertices[1])) continue;
            this.addVertex(arrayList.get((int)n).vertices[1]);
        }
        this.faces = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            IEdge iEdge = arrayList.get(n);
            IFace[] iFaceArray = iEdge.createFace(iMeshType);
            if (iFaceArray == null) continue;
            for (int i = 0; i < iFaceArray.length; ++i) {
                Object object = IG.lock;
                synchronized (object) {
                    boolean bl = true;
                    for (int j = 0; j < this.faces.size() && bl; ++j) {
                        IFace iFace = this.faces.get(j);
                        if (iFace != iFaceArray[i]) continue;
                        bl = false;
                    }
                    if (bl) {
                        this.faces.add(iFaceArray[i]);
                    } else {
                        iFaceArray[i].del();
                    }
                    continue;
                }
            }
        }
    }

    public void initWithPointMatrix(IVec[][] iVecArray, int n, int n2, boolean bl, IMeshType iMeshType) {
        int n3;
        int n4;
        IVertex[][] iVertexArray = new IVertex[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                iVertexArray[i][j] = iMeshType.createVertex(iVecArray[i][j]);
                this.addVertex(iVertexArray[i][j]);
            }
        }
        IEdge[][] iEdgeArray = new IEdge[n - 1][n2];
        IEdge[][] iEdgeArray2 = new IEdge[n][n2 - 1];
        for (n4 = 0; n4 < n - 1; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                iEdgeArray[n4][n3] = iMeshType.createEdge(iVertexArray[n4][n3], iVertexArray[n4 + 1][n3]);
                this.edges.add(iEdgeArray[n4][n3]);
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                iEdgeArray2[n4][n3] = iMeshType.createEdge(iVertexArray[n4][n3], iVertexArray[n4][n3 + 1]);
                this.edges.add(iEdgeArray2[n4][n3]);
            }
        }
        IEdge[] iEdgeArray3 = new IEdge[3];
        for (n3 = 0; n3 < n - 1; ++n3) {
            for (int i = 0; i < n2 - 1; ++i) {
                IEdge iEdge;
                if (bl) {
                    iEdge = iMeshType.createEdge(iVertexArray[n3][i], iVertexArray[n3 + 1][i + 1]);
                    this.edges.add(iEdge);
                    iEdgeArray3[0] = iEdgeArray[n3][i];
                    iEdgeArray3[1] = iEdge;
                    iEdgeArray3[2] = iEdgeArray2[n3 + 1][i];
                    this.faces.add(iMeshType.createFace(iEdgeArray3));
                    iEdgeArray3[0] = iEdgeArray2[n3][i];
                    iEdgeArray3[1] = iEdgeArray[n3][i + 1];
                    iEdgeArray3[2] = iEdge;
                    this.faces.add(iMeshType.createFace(iEdgeArray3));
                    continue;
                }
                iEdge = iMeshType.createEdge(iVertexArray[n3 + 1][i], iVertexArray[n3][i + 1]);
                this.edges.add(iEdge);
                iEdgeArray3[0] = iEdgeArray[n3][i];
                iEdgeArray3[1] = iEdgeArray2[n3][i];
                iEdgeArray3[2] = iEdge;
                this.faces.add(iMeshType.createFace(iEdgeArray3));
                iEdgeArray3[0] = iEdgeArray[n3][i + 1];
                iEdgeArray3[1] = iEdgeArray2[n3 + 1][i];
                iEdgeArray3[2] = iEdge;
                this.faces.add(iMeshType.createFace(iEdgeArray3));
            }
        }
    }

    @Override
    public int vertexNum() {
        return this.vertices.size();
    }

    @Override
    public int edgeNum() {
        return this.edges.size();
    }

    @Override
    public int faceNum() {
        return this.faces.size();
    }

    @Override
    public int vertexNum(ISwitchE iSwitchE) {
        return this.vertexNum();
    }

    @Override
    public int edgeNum(ISwitchE iSwitchE) {
        return this.edgeNum();
    }

    @Override
    public int faceNum(ISwitchE iSwitchE) {
        return this.faceNum();
    }

    @Override
    public IInteger vertexNum(ISwitchR iSwitchR) {
        return new IInteger(this.vertexNum());
    }

    @Override
    public IInteger edgeNum(ISwitchR iSwitchR) {
        return new IInteger(this.edgeNum());
    }

    @Override
    public IInteger faceNum(ISwitchR iSwitchR) {
        return new IInteger(this.faceNum());
    }

    @Override
    public IVertex vertex(int n) {
        return this.vertices.get(n);
    }

    @Override
    public IEdge edge(int n) {
        return this.edges.get(n);
    }

    @Override
    public IFace face(int n) {
        return this.faces.get(n);
    }

    @Override
    public IVertex vertex(IIntegerI iIntegerI) {
        return this.vertices.get(iIntegerI.x());
    }

    @Override
    public IEdge edge(IIntegerI iIntegerI) {
        return this.edges.get(iIntegerI.x());
    }

    @Override
    public IFace face(IIntegerI iIntegerI) {
        return this.faces.get(iIntegerI.x());
    }

    @Override
    public ArrayList<IVertex> vertices() {
        return this.vertices;
    }

    @Override
    public ArrayList<IEdge> edges() {
        return this.edges;
    }

    @Override
    public ArrayList<IFace> faces() {
        return this.faces;
    }

    @Override
    public IVec center() {
        IVec iVec = new IVec();
        if (this.vertices.size() == 0) {
            return iVec;
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            iVec.add(this.vertices.get(i).pos());
        }
        return iVec.div(this.vertices.size());
    }

    public void deleteUnlinked() {
        int n;
        for (n = 0; n < this.faces.size(); ++n) {
            if (!this.faces.get((int)n).deleted) continue;
            this.faces.remove(n);
            --n;
        }
        for (n = 0; n < this.edges.size(); ++n) {
            if (this.edges.get((int)n).faces.size() != 0) continue;
            this.edges.get(n).del();
            this.edges.remove(n);
            --n;
        }
        for (n = 0; n < this.vertices.size(); ++n) {
            if (this.vertices.get((int)n).faces.size() != 0 && this.vertices.get((int)n).edges.size() > 1 && this.vertices.get((int)n).linkedVertices.size() > 1) continue;
            this.vertices.get(n).del();
            this.vertices.remove(n);
            --n;
        }
    }

    @Override
    public IMeshGeo deleteVertex(IVertex iVertex) {
        iVertex.del();
        this.vertices.remove(iVertex);
        this.deleteUnlinked();
        return this;
    }

    @Override
    public IMeshGeo deleteEdge(IEdge iEdge) {
        iEdge.del();
        this.edges.remove(iEdge);
        this.deleteUnlinked();
        return this;
    }

    @Override
    public IMeshGeo deleteFace(IFace iFace) {
        iFace.del();
        this.faces.remove(iFace);
        this.deleteUnlinked();
        return this;
    }

    @Override
    public IMeshGeo deleteVertex(int n) {
        return this.deleteVertex(this.vertex(n));
    }

    @Override
    public IMeshGeo deleteEdge(int n) {
        return this.deleteEdge(this.edge(n));
    }

    @Override
    public IMeshGeo deleteFace(int n) {
        return this.deleteFace(this.face(n));
    }

    @Override
    public IMeshGeo deleteVertex(IIntegerI iIntegerI) {
        return this.deleteVertex(iIntegerI.x());
    }

    @Override
    public IMeshGeo deleteEdge(IIntegerI iIntegerI) {
        return this.deleteEdge(iIntegerI.x());
    }

    @Override
    public IMeshGeo deleteFace(IIntegerI iIntegerI) {
        return this.deleteFace(iIntegerI.x());
    }

    public int getIndex(IVertex iVertex) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.vertices.get(i) != iVertex) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(IEdge iEdge) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i) != iEdge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(IFace iFace) {
        for (int i = 0; i < this.faces.size(); ++i) {
            if (this.faces.get(i) != iFace) continue;
            return i;
        }
        return -1;
    }

    public void addFace(IFace iFace) {
        int n;
        if (!this.faces.contains(iFace)) {
            this.faces.add(iFace);
        }
        for (n = 0; n < iFace.edges.length; ++n) {
            if (this.edges.contains(iFace.edges[n])) continue;
            this.edges.add(iFace.edges[n]);
        }
        for (n = 0; n < iFace.vertices.length; ++n) {
            if (this.vertices.contains(iFace.vertices[n])) continue;
            this.addVertex(iFace.vertices[n]);
        }
    }

    public void addFace(IFace iFace, boolean bl, boolean bl2, boolean bl3) {
        int n;
        for (n = 0; n < iFace.vertices.length; ++n) {
            if (bl && this.vertices.contains(iFace.vertices[n])) continue;
            this.addVertex(iFace.vertices[n]);
        }
        for (n = 0; n < iFace.edges.length; ++n) {
            if (bl2 && this.edges.contains(iFace.edges[n])) continue;
            this.edges.add(iFace.edges[n]);
        }
        if (!bl3 || !this.faces.contains(iFace)) {
            this.faces.add(iFace);
        }
    }

    public void addTriangles(IVertex[] iVertexArray) {
        for (int i = 0; i < iVertexArray.length - 2; i += 3) {
            IFace iFace = new IFace(iVertexArray[i], iVertexArray[i + 1], iVertexArray[i + 2]);
            this.addFace(iFace, true, false, false);
        }
    }

    public void addTriangles(IVec[] iVecArray) {
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            IFace iFace = new IFace(new IVertex(iVecArray[i]), new IVertex(iVecArray[i + 1]), new IVertex(iVecArray[i + 2]));
            this.addFace(iFace, false, false, false);
        }
    }

    public void addQuads(IVertex[] iVertexArray) {
        for (int i = 0; i < iVertexArray.length - 3; i += 4) {
            IFace iFace = new IFace(iVertexArray[i], iVertexArray[i + 1], iVertexArray[i + 2], iVertexArray[i + 3]);
            this.addFace(iFace, true, false, false);
        }
    }

    public void addQuads(IVec[] iVecArray) {
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            IFace iFace = new IFace(new IVertex(iVecArray[i]), new IVertex(iVecArray[i + 1]), new IVertex(iVecArray[i + 2]), new IVertex(iVecArray[i + 3]));
            this.addFace(iFace, true, false, false);
        }
    }

    public void addPolygon(IVertex[] iVertexArray) {
        if (iVertexArray.length < 3) {
            return;
        }
        IFace iFace = new IFace(iVertexArray);
        this.addFace(iFace, true, false, false);
    }

    public void addPolygon(IVec[] iVecArray) {
        if (iVecArray.length < 3) {
            return;
        }
        IVertex[] iVertexArray = new IVertex[iVecArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            iVertexArray[i] = new IVertex(iVecArray[i]);
        }
        IFace iFace = new IFace(iVertexArray);
        this.addFace(iFace, false, false, false);
    }

    public void addTriangleStrip(IVertex[] iVertexArray) {
        int n;
        if (iVertexArray.length < 3) {
            return;
        }
        for (int i = 0; i < iVertexArray.length; ++i) {
            if (this.vertices.contains(iVertexArray[i])) continue;
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[iVertexArray.length - 1];
        IEdge[] iEdgeArray2 = new IEdge[iVertexArray.length - 2];
        for (n = 0; n < iVertexArray.length - 1; ++n) {
            iEdgeArray[n] = new IEdge(iVertexArray[n], iVertexArray[n + 1]);
            this.edges.add(iEdgeArray[n]);
        }
        for (n = 0; n < iVertexArray.length - 2; ++n) {
            iEdgeArray2[n] = new IEdge(iVertexArray[n], iVertexArray[n + 2]);
            this.edges.add(iEdgeArray2[n]);
        }
        for (n = 0; n < iVertexArray.length - 2; ++n) {
            IFace iFace = n % 2 == 0 ? new IFace(iEdgeArray[n], iEdgeArray[n + 1], iEdgeArray2[n]) : new IFace(iEdgeArray[n], iEdgeArray2[n], iEdgeArray[n + 1]);
            this.faces.add(iFace);
        }
    }

    public void addTriangleStrip(IVec[] iVecArray) {
        int n;
        if (iVecArray.length < 3) {
            return;
        }
        IVertex[] iVertexArray = new IVertex[iVecArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            iVertexArray[i] = new IVertex(iVecArray[i]);
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[iVecArray.length - 1];
        IEdge[] iEdgeArray2 = new IEdge[iVecArray.length - 2];
        for (n = 0; n < iVecArray.length - 1; ++n) {
            iEdgeArray[n] = new IEdge(iVertexArray[n], iVertexArray[n + 1]);
            this.edges.add(iEdgeArray[n]);
        }
        for (n = 0; n < iVecArray.length - 2; ++n) {
            iEdgeArray2[n] = new IEdge(iVertexArray[n], iVertexArray[n + 2]);
            this.edges.add(iEdgeArray2[n]);
        }
        for (n = 0; n < iVecArray.length - 2; ++n) {
            IFace iFace = n % 2 == 0 ? new IFace(iEdgeArray[n], iEdgeArray[n + 1], iEdgeArray2[n]) : new IFace(iEdgeArray[n], iEdgeArray2[n], iEdgeArray[n + 1]);
            this.faces.add(iFace);
        }
    }

    public void addQuadStrip(IVertex[] iVertexArray) {
        int n;
        if (iVertexArray.length < 4) {
            return;
        }
        int n2 = iVertexArray.length / 2;
        for (int i = 0; i < n2 * 2; ++i) {
            if (this.vertices.contains(iVertexArray[i])) continue;
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[n2];
        IEdge[] iEdgeArray2 = new IEdge[n2 - 1];
        IEdge[] iEdgeArray3 = new IEdge[n2 - 1];
        for (n = 0; n < n2; ++n) {
            iEdgeArray[n] = new IEdge(iVertexArray[n * 2], iVertexArray[n * 2 + 1]);
            this.edges.add(iEdgeArray[n]);
        }
        for (n = 0; n < n2 - 1; ++n) {
            iEdgeArray2[n] = new IEdge(iVertexArray[n * 2], iVertexArray[n * 2 + 2]);
            this.edges.add(iEdgeArray2[n]);
        }
        for (n = 0; n < n2 - 1; ++n) {
            iEdgeArray3[n] = new IEdge(iVertexArray[n * 2 + 1], iVertexArray[n * 2 + 3]);
            this.edges.add(iEdgeArray3[n]);
        }
        for (n = 0; n < n2 - 1; ++n) {
            IFace iFace = new IFace(iEdgeArray[n], iEdgeArray3[n], iEdgeArray[n + 1], iEdgeArray2[n]);
            this.faces.add(iFace);
        }
    }

    public void addQuadStrip(IVec[] iVecArray) {
        int n;
        if (iVecArray.length < 4) {
            return;
        }
        int n2 = iVecArray.length / 2;
        IVertex[] iVertexArray = new IVertex[n2 * 2];
        for (int i = 0; i < n2 * 2; ++i) {
            iVertexArray[i] = new IVertex(iVecArray[i]);
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[n2];
        IEdge[] iEdgeArray2 = new IEdge[n2 - 1];
        IEdge[] iEdgeArray3 = new IEdge[n2 - 1];
        for (n = 0; n < n2; ++n) {
            iEdgeArray[n] = new IEdge(iVertexArray[n * 2], iVertexArray[n * 2 + 1]);
            this.edges.add(iEdgeArray[n]);
        }
        for (n = 0; n < n2 - 1; ++n) {
            iEdgeArray2[n] = new IEdge(iVertexArray[n * 2], iVertexArray[n * 2 + 2]);
            this.edges.add(iEdgeArray2[n]);
        }
        for (n = 0; n < n2 - 1; ++n) {
            iEdgeArray3[n] = new IEdge(iVertexArray[n * 2 + 1], iVertexArray[n * 2 + 3]);
            this.edges.add(iEdgeArray3[n]);
        }
        for (n = 0; n < n2 - 1; ++n) {
            IFace iFace = new IFace(iEdgeArray[n], iEdgeArray3[n], iEdgeArray[n + 1], iEdgeArray2[n]);
            this.faces.add(iFace);
        }
    }

    public void addTriangleFan(IVertex[] iVertexArray) {
        int n;
        if (iVertexArray.length < 3) {
            return;
        }
        for (int i = 0; i < iVertexArray.length; ++i) {
            if (this.vertices.contains(iVertexArray[i])) continue;
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[iVertexArray.length - 1];
        IEdge[] iEdgeArray2 = new IEdge[iVertexArray.length - 2];
        for (n = 1; n < iVertexArray.length; ++n) {
            iEdgeArray[n - 1] = new IEdge(iVertexArray[0], iVertexArray[n]);
            this.edges.add(iEdgeArray[n - 1]);
        }
        for (n = 1; n < iVertexArray.length - 1; ++n) {
            iEdgeArray2[n - 1] = new IEdge(iVertexArray[n], iVertexArray[n + 1]);
            this.edges.add(iEdgeArray2[n - 1]);
        }
        for (n = 0; n < iVertexArray.length - 2; ++n) {
            IFace iFace = new IFace(iEdgeArray[n], iEdgeArray2[n], iEdgeArray[n + 1]);
            this.faces.add(iFace);
        }
    }

    public void addTriangleFan(IVec[] iVecArray) {
        int n;
        if (iVecArray.length < 3) {
            return;
        }
        IVertex[] iVertexArray = new IVertex[iVecArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            iVertexArray[i] = new IVertex(iVecArray[i]);
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[iVecArray.length - 1];
        IEdge[] iEdgeArray2 = new IEdge[iVecArray.length - 2];
        for (n = 1; n < iVecArray.length; ++n) {
            iEdgeArray[n - 1] = new IEdge(iVertexArray[0], iVertexArray[n]);
            this.edges.add(iEdgeArray[n - 1]);
        }
        for (n = 1; n < iVecArray.length - 1; ++n) {
            iEdgeArray2[n - 1] = new IEdge(iVertexArray[n], iVertexArray[n + 1]);
            this.edges.add(iEdgeArray2[n - 1]);
        }
        for (n = 0; n < iVecArray.length - 2; ++n) {
            IFace iFace = new IFace(iEdgeArray[n], iEdgeArray2[n], iEdgeArray[n + 1]);
            this.faces.add(iFace);
        }
    }

    public IVertex insertVertex(IFace iFace, IVertex iVertex, IMeshType iMeshType) {
        int n;
        for (int i = 0; i < iFace.vertices.length; ++i) {
            if (!iFace.vertices[i].pos.eq(iVertex.pos)) continue;
            return iFace.vertices[i];
        }
        IEdge iEdge = null;
        int n2 = -1;
        for (int i = 0; i < iFace.edges.length && iEdge == null; ++i) {
            if (!iFace.edges[i].isOnEdge(iVertex)) continue;
            iEdge = iFace.edges[i];
            n2 = i;
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        int n3 = iFace.edges.length;
        IEdge[] iEdgeArray = new IEdge[n3];
        for (int i = 0; i < n3; ++i) {
            IVertex iVertex2 = iFace.edges[i].getSharedVertex(iFace.edges[(i + 1) % n3]);
            iEdgeArray[i] = iMeshType.createEdge(iVertex2, iVertex);
            if (n2 < 0 || i != n2 && i + 1 != n2) continue;
            arrayList.add(iEdgeArray[i]);
        }
        IFace[] iFaceArray = new IFace[n3];
        for (n = 0; n < n3; ++n) {
            if (n == n2) continue;
            IEdge[] iEdgeArray2 = new IEdge[]{iFace.edges[n], iEdgeArray[n], iEdgeArray[(n - 1 + n3) % n3]};
            iFaceArray[n] = iMeshType.createFace(iEdgeArray2);
        }
        if (!this.vertices.contains(iVertex)) {
            this.addVertex(iVertex);
        }
        for (n = 0; n < n3; ++n) {
            this.edges.add(iEdgeArray[n]);
            if (iFaceArray[n] == null) continue;
            this.faces.add(iFaceArray[n]);
        }
        iFace.del();
        this.faces.remove(iFace);
        if (iEdge != null) {
            if (arrayList.size() != 2) {
                IOut.err("new edges for on-edge insertion point cannot be found");
            }
            for (n = 0; n < iEdge.faces.size(); ++n) {
                this.replaceEdge(iEdge.faces.get(n), iEdge, (IEdge)arrayList.get(0), (IEdge)arrayList.get(1), iVertex, iMeshType);
            }
            iEdge.del();
            this.edges.remove(iEdge);
        }
        return iVertex;
    }

    public void replaceEdge(IFace iFace, IEdge iEdge, IEdge iEdge2, IEdge iEdge3, IVertex iVertex, IMeshType iMeshType) {
        int n;
        int n2 = iFace.indexOf(iEdge);
        if (n2 < 0) {
            IOut.err("specified edge is not included in the face");
            return;
        }
        IVertex iVertex2 = iEdge2.getOtherVertex(iVertex);
        IVertex iVertex3 = iEdge3.getOtherVertex(iVertex);
        int n3 = iFace.edges.length;
        IEdge[] iEdgeArray = new IEdge[n3];
        for (int i = 0; i < n3; ++i) {
            IVertex iVertex4 = iFace.edges[i].getSharedVertex(iFace.edges[(i + 1) % n3]);
            iEdgeArray[i] = iVertex4 == iVertex2 ? iEdge2 : (iVertex4 == iVertex3 ? iEdge3 : iMeshType.createEdge(iVertex4, iVertex));
        }
        IFace[] iFaceArray = new IFace[n3];
        for (n = 0; n < n3; ++n) {
            if (n == n2) continue;
            IEdge[] iEdgeArray2 = new IEdge[]{iFace.edges[n], iEdgeArray[n], iEdgeArray[(n - 1 + n3) % n3]};
            iFaceArray[n] = iMeshType.createFace(iEdgeArray2);
        }
        if (!this.vertices.contains(iVertex)) {
            this.addVertex(iVertex);
        }
        for (n = 0; n < n3; ++n) {
            if (iEdgeArray[n] != iEdge2 && iEdgeArray[n] != iEdge3) {
                this.edges.add(iEdgeArray[n]);
            }
            if (iFaceArray[n] == null) continue;
            this.faces.add(iFaceArray[n]);
        }
        iFace.del();
        this.faces.remove(iFace);
    }

    public void divideEdge(IEdge iEdge, double d, IMeshType iMeshType) {
        int n;
        IVertex iVertex = iEdge.vertices[0];
        IVertex iVertex2 = iEdge.vertices[1];
        IVertex iVertex3 = iMeshType.createVertex(iVertex2.pos.dup().get().sum(iVertex.pos, 1.0 - d));
        IEdge iEdge2 = iMeshType.createEdge(iVertex, iVertex3);
        IEdge iEdge3 = iMeshType.createEdge(iVertex3, iVertex2);
        this.addVertex(iVertex3);
        this.edges.add(iEdge2);
        this.edges.add(iEdge3);
        for (n = 0; n < iEdge.faces.size(); ++n) {
            IEdge[] iEdgeArray;
            Object object;
            IEdge[] iEdgeArray2;
            Object object2;
            IEdge iEdge4;
            IEdge iEdge5;
            IEdge iEdge6;
            IVertex[] iVertexArray;
            if (iEdge.faces.get(n).vertexNum() == 3) {
                iVertexArray = iEdge.faces.get(n).getOtherVertex(iVertex, iVertex2);
                if (iVertexArray != null) {
                    iEdge6 = iMeshType.createEdge((IVertex)iVertexArray, iVertex3);
                    this.edges.add(iEdge6);
                    iEdge5 = iEdge.faces.get(n).getEdge((IVertex)iVertexArray, iVertex);
                    iEdge4 = iEdge.faces.get(n).getEdge((IVertex)iVertexArray, iVertex2);
                    object2 = new IEdge[]{iEdge5, iEdge2, iEdge6};
                    iEdgeArray2 = iMeshType.createFace((IEdge[])object2);
                    object = new IEdge[]{iEdge4, iEdge3, iEdge6};
                    iEdgeArray = iMeshType.createFace((IEdge[])object);
                    this.faces.add((IFace)iEdgeArray2);
                    this.faces.add((IFace)iEdgeArray);
                    continue;
                }
                IOut.err("no opposite vertex!");
                continue;
            }
            iVertexArray = iEdge.faces.get(n).getAdjacentVertices(iVertex, iVertex2);
            if (iVertexArray != null) {
                IEdge[] iEdgeArray3;
                IEdge[] iEdgeArray4;
                iEdge6 = iMeshType.createEdge(iVertexArray[0], iVertex3);
                this.edges.add(iEdge6);
                iEdge5 = iMeshType.createEdge(iVertexArray[1], iVertex3);
                this.edges.add(iEdge5);
                iEdge4 = iEdge.faces.get(n).getEdge(iVertexArray[0], iVertex);
                object2 = iEdge.faces.get(n).getEdge(iVertexArray[1], iVertex2);
                iEdgeArray2 = new IEdge[]{iEdge4, iEdge2, iEdge6};
                object = iMeshType.createFace(iEdgeArray2);
                iEdgeArray = new IEdge[]{object2, iEdge3, iEdge5};
                IFace iFace = iMeshType.createFace(iEdgeArray);
                IFace iFace2 = null;
                if (iEdge.faces.get(n).vertexNum() == 4) {
                    iEdgeArray4 = iEdge.faces.get(n).getEdge(iVertexArray[0], iVertexArray[1]);
                    iEdgeArray3 = new IEdge[]{iEdge6, iEdge5, iEdgeArray4};
                    iFace2 = iMeshType.createFace(iEdgeArray3);
                } else {
                    iEdgeArray4 = iEdge.faces.get(n).getOtherEdges(iVertex, iVertex2, iVertexArray[0], iVertexArray[1]);
                    iEdgeArray3 = new IEdge[2 + iEdgeArray4.length];
                    iEdgeArray3[0] = iEdge6;
                    iEdgeArray3[1] = iEdge5;
                    int n2 = 0;
                    while (n2 < iEdgeArray4.length) {
                        iEdgeArray3[2 + n2] = iEdgeArray4[n2];
                        ++n;
                    }
                    iFace2 = iMeshType.createFace(iEdgeArray3);
                }
                this.faces.add((IFace)object);
                this.faces.add(iFace);
                this.faces.add(iFace2);
                continue;
            }
            IOut.err("no opposite vertex!");
        }
        for (n = 0; n < iEdge.faces.size(); ++n) {
            this.faces.remove(iEdge.faces.get(n));
            iEdge.faces.get(n).del();
        }
        this.edges.remove(iEdge);
        iEdge.del();
    }

    public IEdge[] divideEdge(IEdge iEdge, double[] dArray, IMeshType iMeshType) {
        int n;
        IVertex iVertex = iEdge.vertices[0];
        IVertex iVertex2 = iEdge.vertices[1];
        IVecI iVecI = iVertex.nml();
        IVecI iVecI2 = iVertex2.nml();
        IVertex[] iVertexArray = new IVertex[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            iVertexArray[i] = iMeshType.createVertex(iVertex2.pos.dup().get().sum(iVertex.pos, 1.0 - dArray[i]));
            iVertexArray[i].setNormal(iVecI.sum(iVecI2, dArray[i]));
            this.addVertex(iVertexArray[i]);
        }
        IEdge[] iEdgeArray = new IEdge[iVertexArray.length + 1];
        for (n = 0; n <= iVertexArray.length; ++n) {
            iEdgeArray[n] = n == 0 ? iMeshType.createEdge(iVertex, iVertexArray[n]) : (n == iVertexArray.length ? iMeshType.createEdge(iVertexArray[n - 1], iVertex2) : iMeshType.createEdge(iVertexArray[n - 1], iVertexArray[n]));
            this.edges.add(iEdgeArray[n]);
        }
        for (n = 0; n < iEdge.faces.size(); ++n) {
            IEdge[] iEdgeArray2;
            int n2;
            Object object;
            Object object2;
            IVertex[] iVertexArray2;
            if (iEdge.faces.get(n).vertexNum() == 3) {
                iVertexArray2 = iEdge.faces.get(n).getOtherVertex(iVertex, iVertex2);
                if (iVertexArray2 != null) {
                    IEdge[] iEdgeArray3 = new IEdge[iVertexArray.length];
                    for (int i = 0; i < iVertexArray.length; ++i) {
                        iEdgeArray3[i] = iMeshType.createEdge((IVertex)iVertexArray2, iVertexArray[i]);
                        this.edges.add(iEdgeArray3[i]);
                    }
                    object2 = iEdge.faces.get(n).getEdge((IVertex)iVertexArray2, iVertex);
                    object = iEdge.faces.get(n).getEdge((IVertex)iVertexArray2, iVertex2);
                    for (n2 = 0; n2 <= iVertexArray.length; ++n2) {
                        if (n2 == 0) {
                            iEdgeArray2 = new IEdge[]{object2, iEdgeArray[n2], iEdgeArray3[n2]};
                            this.faces.add(iMeshType.createFace(iEdgeArray2));
                            continue;
                        }
                        if (n2 == iVertexArray.length) {
                            iEdgeArray2 = new IEdge[]{iEdgeArray3[n2 - 1], iEdgeArray[n2], object};
                            this.faces.add(iMeshType.createFace(iEdgeArray2));
                            continue;
                        }
                        iEdgeArray2 = new IEdge[]{iEdgeArray3[n2 - 1], iEdgeArray[n2], iEdgeArray3[n2]};
                        this.faces.add(iMeshType.createFace(iEdgeArray2));
                    }
                    continue;
                }
                IOut.err("no opposite vertex!");
                continue;
            }
            iVertexArray2 = iEdge.faces.get(n).getAdjacentVertices(iVertex, iVertex2);
            if (iVertexArray2 != null) {
                IFace iFace;
                IEdge[] iEdgeArray4;
                IEdge[] iEdgeArray5;
                int n3;
                int n4 = 0;
                for (int i = 0; i < dArray.length; ++i) {
                    if (!(dArray[i] < 0.5)) continue;
                    ++n4;
                }
                if (n4 >= dArray.length) {
                    n4 = dArray.length - 1;
                }
                object2 = new IEdge[n4 + 1];
                object = new IEdge[iVertexArray.length - n4];
                for (n2 = 0; n2 <= n4; ++n2) {
                    object2[n2] = iMeshType.createEdge(iVertexArray2[0], iVertexArray[n2]);
                    this.edges.add(object2[n2]);
                }
                for (n2 = n4; n2 < iVertexArray.length; ++n2) {
                    object[n2 - n4] = iMeshType.createEdge(iVertexArray2[1], iVertexArray[n2]);
                    this.edges.add(object[n2 - n4]);
                }
                IEdge iEdge2 = iEdge.faces.get(n).getEdge(iVertexArray2[0], iVertex);
                iEdgeArray2 = iEdge.faces.get(n).getEdge(iVertexArray2[1], iVertex2);
                for (n3 = 0; n3 <= n4; ++n3) {
                    if (n3 == 0) {
                        iEdgeArray5 = new IEdge[]{iEdge2, iEdgeArray[n3], object2[n3]};
                        this.faces.add(iMeshType.createFace(iEdgeArray5));
                        continue;
                    }
                    iEdgeArray5 = new IEdge[]{object2[n3 - 1], iEdgeArray[n3], object2[n3]};
                    this.faces.add(iMeshType.createFace(iEdgeArray5));
                }
                for (n3 = n4; n3 < iVertexArray.length; ++n3) {
                    if (n3 == iVertexArray.length - 1) {
                        iEdgeArray5 = new IEdge[]{object[n3 - n4], iEdgeArray[n3 + 1], iEdgeArray2};
                        this.faces.add(iMeshType.createFace(iEdgeArray5));
                        continue;
                    }
                    iEdgeArray5 = new IEdge[]{object[n3 - n4], iEdgeArray[n3 + 1], object[n3 + 1 - n4]};
                    this.faces.add(iMeshType.createFace(iEdgeArray5));
                }
                if (iEdge.faces.get(n).vertexNum() == 4) {
                    iEdgeArray4 = iEdge.faces.get(n).getEdge(iVertexArray2[0], iVertexArray2[1]);
                    iEdgeArray5 = new IEdge[]{object2[((IEdge[])object2).length - 1], object[0], iEdgeArray4};
                    iFace = iMeshType.createFace(iEdgeArray5);
                    this.faces.add(iFace);
                    continue;
                }
                iEdgeArray4 = iEdge.faces.get(n).getOtherEdges(iVertex, iVertex2, iVertexArray2[0], iVertexArray2[1]);
                iEdgeArray5 = new IEdge[2 + iEdgeArray4.length];
                iEdgeArray5[0] = object2[((IEdge[])object2).length - 1];
                iEdgeArray5[1] = object[0];
                int n5 = 0;
                while (n5 < iEdgeArray4.length) {
                    iEdgeArray5[2 + n5] = iEdgeArray4[n5];
                    ++n;
                }
                iFace = iMeshType.createFace(iEdgeArray5);
                this.faces.add(iFace);
                continue;
            }
            IOut.err("no opposite vertex!");
        }
        for (n = 0; n < iEdge.faces.size(); ++n) {
            this.faces.remove(iEdge.faces.get(n));
            iEdge.faces.get(n).del();
        }
        this.edges.remove(iEdge);
        iEdge.del();
        return iEdgeArray;
    }

    public IMeshGeo divideFace(IFace iFace, IEdge iEdge, IVertex iVertex, IEdge iEdge2, IVertex iVertex2, IMeshType iMeshType) {
        if (!iFace.contains(iEdge) || !iFace.contains(iEdge2)) {
            IOut.err("edges are not included in the face");
            return this;
        }
        IEdge iEdge3 = iMeshType.createEdge(iVertex, iVertex2);
        IEdge iEdge4 = iMeshType.createEdge(iEdge.vertices[0], iVertex);
        IEdge iEdge5 = iMeshType.createEdge(iVertex, iEdge.vertices[1]);
        IEdge iEdge6 = iMeshType.createEdge(iEdge2.vertices[0], iVertex2);
        IEdge iEdge7 = iMeshType.createEdge(iVertex2, iEdge2.vertices[1]);
        int n = iFace.indexOf(iEdge);
        int n2 = iFace.indexOf(iEdge2);
        if (n < 0 || n2 < 0) {
            IOut.err("edges are not included in the face");
            return this;
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        int n3 = iFace.edges.length;
        arrayList.add(iEdge3);
        if (iFace.edges[(n + 1) % n3].hasSharedVertex(iEdge4)) {
            arrayList.add(iEdge4);
        } else if (iFace.edges[(n + 1) % n3].hasSharedVertex(iEdge5)) {
            arrayList.add(iEdge5);
        }
        int n4 = n + 1;
        while (n4 % n3 != n2) {
            arrayList.add(iFace.edges[n4 % n3]);
            ++n4;
        }
        if (iFace.edges[(n2 - 1 + n3) % n3].hasSharedVertex(iEdge4)) {
            arrayList.add(iEdge4);
        } else if (iFace.edges[(n2 - 1 + n3) % n3].hasSharedVertex(iEdge5)) {
            arrayList.add(iEdge5);
        }
        arrayList2.add(iEdge3);
        if (iFace.edges[(n2 + 1) % n3].hasSharedVertex(iEdge6)) {
            arrayList2.add(iEdge6);
        } else if (iFace.edges[(n2 + 1) % n3].hasSharedVertex(iEdge7)) {
            arrayList2.add(iEdge7);
        }
        n4 = n2 + 1;
        while (n4 % n3 != n) {
            arrayList2.add(iFace.edges[n4 % n3]);
            ++n4;
        }
        if (iFace.edges[(n - 1 + n3) % n3].hasSharedVertex(iEdge6)) {
            arrayList2.add(iEdge6);
        } else if (iFace.edges[(n - 1 + n3) % n3].hasSharedVertex(iEdge7)) {
            arrayList2.add(iEdge7);
        }
        IEdge[] iEdgeArray = new IEdge[arrayList.size()];
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            iEdgeArray[n4] = (IEdge)arrayList.get(n4);
        }
        IEdge[] iEdgeArray2 = new IEdge[arrayList2.size()];
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            iEdgeArray2[n4] = (IEdge)arrayList2.get(n4);
        }
        IFace iFace2 = iMeshType.createFace(iEdgeArray);
        IFace iFace3 = iMeshType.createFace(iEdgeArray2);
        this.faces.add(iFace2);
        this.faces.add(iFace3);
        this.faces.remove(iFace);
        iFace.del();
        if (iEdge.faces.size() == 0) {
            this.edges.remove(iEdge);
            iEdge.del();
        }
        if (iEdge2.faces.size() == 0) {
            this.edges.remove(iEdge2);
            iEdge2.del();
        }
        return this;
    }

    public IMeshGeo triangulate(IFace iFace, boolean bl, IMeshType iMeshType) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<Object> arrayList3 = iFace.triangulate(bl, iMeshType);
        for (n = 0; n < arrayList3.size(); ++n) {
            if (arrayList3.get(n) instanceof IEdge) {
                arrayList2.add((IEdge)arrayList3.get(n));
                continue;
            }
            if (!(arrayList3.get(n) instanceof IFace)) continue;
            arrayList.add((IFace)arrayList3.get(n));
        }
        iFace.del();
        this.faces.remove(iFace);
        for (n = 0; n < arrayList2.size(); ++n) {
            this.edges.add((IEdge)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.faces.add((IFace)arrayList.get(n));
        }
        return this;
    }

    public IMeshGeo triangulate() {
        return this.triangulate(true, new IMeshType());
    }

    public IMeshGeo triangulate(boolean bl) {
        return this.triangulate(bl, new IMeshType());
    }

    public IMeshGeo triangulateAll(boolean bl, IMeshType iMeshType) {
        return this.triangulate(bl, iMeshType);
    }

    public IMeshGeo triangulate(boolean bl, IMeshType iMeshType) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        for (n = 0; n < this.faces.size(); ++n) {
            ArrayList<Object> arrayList3 = this.faces.get(n).triangulate(bl, iMeshType);
            for (int i = 0; arrayList3 != null && i < arrayList3.size(); ++i) {
                if (arrayList3.get(i) instanceof IEdge) {
                    arrayList2.add((IEdge)arrayList3.get(i));
                    continue;
                }
                if (!(arrayList3.get(i) instanceof IFace)) continue;
                arrayList.add((IFace)arrayList3.get(i));
            }
            if (arrayList3 == null) continue;
            this.faces.get(n).del();
            this.faces.remove(n);
            --n;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.edges.add((IEdge)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.faces.add((IFace)arrayList.get(n));
        }
        return this;
    }

    public IMeshGeo triangulateAtCenter() {
        return this.triangulateAtCenter(new IMeshType());
    }

    public IMeshGeo triangulateAtCenter(IMeshType iMeshType) {
        int n;
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IVertex> arrayList3 = new ArrayList<IVertex>();
        for (n = 0; n < this.faces.size(); ++n) {
            ArrayList<Object> arrayList4 = this.faces.get(n).triangulateAtCenter(iMeshType);
            for (int i = 0; arrayList4 != null && i < arrayList4.size(); ++i) {
                if (arrayList4.get(i) instanceof IVertex) {
                    arrayList3.add((IVertex)arrayList4.get(i));
                }
                if (arrayList4.get(i) instanceof IEdge) {
                    arrayList2.add((IEdge)arrayList4.get(i));
                    continue;
                }
                if (!(arrayList4.get(i) instanceof IFace)) continue;
                arrayList.add((IFace)arrayList4.get(i));
            }
            if (arrayList4 == null) continue;
            this.faces.get(n).del();
            this.faces.remove(n);
            --n;
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            this.addVertex((IVertex)arrayList3.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.edges.add((IEdge)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.faces.add((IFace)arrayList.get(n));
        }
        return this;
    }

    public IMeshGeo removeDuplicatedEdge() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.edges.size(); ++n2) {
            for (int i = n2 + 1; i < this.edges.size(); ++i) {
                if ((this.edges.get(n2).vertex(0) != this.edges.get(i).vertex(0) || this.edges.get(n2).vertex(1) != this.edges.get(i).vertex(1)) && (this.edges.get(n2).vertex(0) != this.edges.get(i).vertex(1) || this.edges.get(n2).vertex(1) != this.edges.get(i).vertex(0))) continue;
                for (n = 0; n < this.edges.get((int)i).faces.size(); ++n) {
                    this.edges.get((int)i).faces.get(n).replaceEdge(this.edges.get(i), this.edges.get(n2));
                }
                this.edges.remove(i);
                --i;
            }
        }
        for (n2 = 0; n2 < this.vertices.size(); ++n2) {
            IVertex iVertex = this.vertices.get(n2);
            for (n = 0; n < iVertex.linkedVertices.size(); ++n) {
                IVertex iVertex2 = iVertex.linkedVertices.get(n);
                for (int i = n + 1; i < iVertex.linkedVertices.size(); ++i) {
                    if (iVertex.linkedVertices.get(i) != iVertex2) continue;
                    iVertex.linkedVertices.remove(i);
                    --i;
                }
            }
        }
        return this;
    }

    public IEdge[] nakedEdges() {
        ArrayList<IEdge> arrayList = this.nakedEdges(true);
        return arrayList.toArray(new IEdge[arrayList.size()]);
    }

    public ArrayList<IEdge> nakedEdges(boolean bl) {
        boolean[] blArray = new boolean[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            blArray[i] = false;
            IEdge iEdge = this.edges.get(i);
            if (iEdge.faceNum() != 1) continue;
            if (bl) {
                boolean bl2 = true;
                for (int j = 0; j < i && bl2; ++j) {
                    if (!iEdge.eq(this.edges.get(j))) continue;
                    bl2 = false;
                    blArray[j] = false;
                }
                if (!bl2) continue;
                blArray[i] = true;
                continue;
            }
            blArray[i] = true;
        }
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (int i = 0; i < this.edges.size(); ++i) {
            if (!blArray[i]) continue;
            arrayList.add(this.edges.get(i));
        }
        return arrayList;
    }

    public IMeshGeo subD() {
        return this.subdivide();
    }

    public IMeshGeo subdivide() {
        IVertex[] iVertexArray = new IVertex[this.edges.size()];
        for (int i = 0; i < this.edges.size(); ++i) {
            iVertexArray[i] = new IVertex(this.edges.get(i).vertex(0).get().mid(this.edges.get(i).vertex(1)));
        }
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < this.faces.size(); ++i) {
            IFace iFace = this.faces.get(i);
            if (iFace.vertexNum() != 3) continue;
            IVertex iVertex = iFace.vertex(0);
            IVertex iVertex2 = iFace.vertex(1);
            IVertex iVertex3 = iFace.vertex(2);
            IEdge iEdge = iFace.getEdge(iVertex, iVertex2);
            IEdge iEdge2 = iFace.getEdge(iVertex2, iVertex3);
            IEdge iEdge3 = iFace.getEdge(iVertex3, iVertex);
            int n = this.edges.indexOf(iEdge);
            int n2 = this.edges.indexOf(iEdge2);
            int n3 = this.edges.indexOf(iEdge3);
            if (n < 0 || n2 < 0 || n3 < 0) continue;
            IVertex iVertex4 = iVertexArray[n];
            IVertex iVertex5 = iVertexArray[n2];
            IVertex iVertex6 = iVertexArray[n3];
            IFace iFace2 = new IFace(iVertex, iVertex4, iVertex6);
            IFace iFace3 = new IFace(iVertex2, iVertex5, iVertex4);
            IFace iFace4 = new IFace(iVertex3, iVertex6, iVertex5);
            IFace iFace5 = new IFace(iVertex4, iVertex5, iVertex6);
            arrayList.add(iFace2);
            arrayList.add(iFace3);
            arrayList.add(iFace4);
            arrayList.add(iFace5);
        }
        return new IMeshGeo(arrayList.toArray(new IFace[arrayList.size()]));
    }

    public void subdivideNakedEdges(int n, IMeshType iMeshType) {
        ArrayList<IEdge> arrayList = this.nakedEdges(true);
        ArrayList<ArrayList<IEdge>> arrayList2 = this.findLoop(arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.subdivideNakedEdges(arrayList2.get(i), n, iMeshType);
        }
    }

    public void subdivideNakedEdges(ArrayList<IEdge> arrayList, int n, IMeshType iMeshType) {
        if (n <= 0) {
            return;
        }
        int n2 = arrayList.size();
        IEdge[][] iEdgeArrayArray = new IEdge[n2][];
        for (int i = 0; i < n2; ++i) {
            iEdgeArrayArray[i] = this.divideEdge(arrayList.get(i), new double[]{0.3333333333333333, 0.6666666666666666}, iMeshType);
        }
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        for (int i = 0; i < n2; ++i) {
            IEdge iEdge = null;
            IEdge iEdge2 = null;
            if (iEdgeArrayArray[i][0].isConnected(iEdgeArrayArray[(i + 1) % n2][0])) {
                iEdge = iEdgeArrayArray[i][0];
                iEdge2 = iEdgeArrayArray[(i + 1) % n2][0];
            } else if (iEdgeArrayArray[i][0].isConnected(iEdgeArrayArray[(i + 1) % n2][2])) {
                iEdge = iEdgeArrayArray[i][0];
                iEdge2 = iEdgeArrayArray[(i + 1) % n2][2];
            } else if (iEdgeArrayArray[i][2].isConnected(iEdgeArrayArray[(i + 1) % n2][0])) {
                iEdge = iEdgeArrayArray[i][2];
                iEdge2 = iEdgeArrayArray[(i + 1) % n2][0];
            } else if (iEdgeArrayArray[i][2].isConnected(iEdgeArrayArray[(i + 1) % n2][2])) {
                iEdge = iEdgeArrayArray[i][2];
                iEdge2 = iEdgeArrayArray[(i + 1) % n2][2];
            } else {
                IOut.err("divided edges are not connected.");
            }
            if (iEdge == null || iEdge2 == null) continue;
            IVertex iVertex = iEdge.getSharedVertex(iEdge2);
            IVertex iVertex2 = iEdge.getOtherVertex(iVertex);
            IVertex iVertex3 = iEdge2.getOtherVertex(iVertex);
            if (!iVertex.get().isStraight(iVertex2, iVertex3)) {
                IEdge iEdge3 = iMeshType.createEdge(iVertex2, iVertex3);
                arrayList2.add(iEdgeArrayArray[i][1]);
                arrayList2.add(iEdge3);
                this.edges.add(iEdge3);
                this.faces.add(iMeshType.createFace(new IEdge[]{iEdge3, iEdge, iEdge2}));
                continue;
            }
            arrayList2.add(iEdgeArrayArray[i][1]);
            arrayList2.add(iEdge);
            arrayList2.add(iEdge2);
        }
        if (arrayList2.size() > 2) {
            this.subdivideNakedEdges(arrayList2, n - 1, iMeshType);
        }
    }

    public ArrayList<ArrayList<IEdge>> findLoop(ArrayList<IEdge> arrayList) {
        ArrayList<ArrayList<IEdge>> arrayList2 = new ArrayList<ArrayList<IEdge>>();
        while (arrayList.size() > 0) {
            int n;
            ArrayList<IEdge> arrayList3 = new ArrayList<IEdge>();
            IEdge iEdge = arrayList.get(0);
            arrayList3.add(iEdge);
            arrayList.remove(iEdge);
            IEdge iEdge2 = null;
            for (n = 0; n < arrayList.size() && iEdge2 == null; ++n) {
                if (!arrayList.get(n).isConnected(iEdge)) continue;
                iEdge2 = arrayList.get(n);
            }
            if (iEdge2 == null) {
                IOut.err("loop is not closed. skipped");
                continue;
            }
            arrayList3.add(iEdge2);
            arrayList.remove(iEdge2);
            iEdge = iEdge2;
            while (iEdge2 != null) {
                iEdge2 = null;
                for (n = 0; n < arrayList.size() && iEdge2 == null; ++n) {
                    if (!arrayList.get(n).isConnected(iEdge)) continue;
                    iEdge2 = arrayList.get(n);
                }
                if (iEdge2 != null) {
                    iEdge = iEdge2;
                    arrayList3.add(iEdge);
                    arrayList.remove(iEdge);
                    if (!iEdge.isConnected((IEdge)arrayList3.get(0))) continue;
                    arrayList2.add(arrayList3);
                    iEdge2 = null;
                    continue;
                }
                IOut.err("loop is not closed. skipped");
            }
        }
        return arrayList2;
    }

    public IVec[] getBoundingBox() {
        IVec iVec = new IVec(this.vertices.get(0));
        IVec iVec2 = new IVec(this.vertices.get(0));
        for (int i = 1; i < this.vertices.size(); ++i) {
            IVec iVec3 = this.vertices.get((int)i).pos.get();
            if (iVec3.x < iVec.x) {
                iVec.x = iVec3.x;
            }
            if (iVec3.x > iVec2.x) {
                iVec2.x = iVec3.x;
            }
            if (iVec3.y < iVec.y) {
                iVec.y = iVec3.y;
            }
            if (iVec3.y > iVec2.y) {
                iVec2.y = iVec3.y;
            }
            if (iVec3.z < iVec.z) {
                iVec.z = iVec3.z;
            }
            if (!(iVec3.z > iVec2.z)) continue;
            iVec2.z = iVec3.z;
        }
        IVec[] iVecArray = new IVec[]{iVec, iVec2};
        return iVecArray;
    }

    @Override
    public IMeshGeo close() {
        this.closed = true;
        return this;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public static IMeshGeo joinMesh(IMeshGeo[] iMeshGeoArray) {
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < iMeshGeoArray.length; ++i) {
            for (int j = 0; j < iMeshGeoArray[i].faceNum(); ++j) {
                arrayList.add(iMeshGeoArray[i].face(j));
            }
        }
        IMeshGeo iMeshGeo = new IMeshGeo(arrayList.toArray(new IFace[arrayList.size()]));
        iMeshGeo.removeDuplicates();
        return iMeshGeo;
    }

    public IMeshGeo join(IMeshGeo[] iMeshGeoArray) {
        return this.join(iMeshGeoArray, IConfig.tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeshGeo join(IMeshGeo[] iMeshGeoArray, double d) {
        Object object = IG.lock;
        synchronized (object) {
            for (int i = 0; i < iMeshGeoArray.length; ++i) {
                int n;
                for (n = 0; n < iMeshGeoArray[i].vertexNum(); ++n) {
                    if (this.vertices.contains(iMeshGeoArray[i].vertex(n))) continue;
                    this.addVertex(iMeshGeoArray[i].vertex(n));
                }
                for (n = 0; n < iMeshGeoArray[i].edgeNum(); ++n) {
                    if (this.edges.contains(iMeshGeoArray[i].edge(n))) continue;
                    this.edges.add(iMeshGeoArray[i].edge(n));
                }
                for (n = 0; n < iMeshGeoArray[i].faceNum(); ++n) {
                    if (this.faces.contains(iMeshGeoArray[i].face(n))) continue;
                    this.faces.add(iMeshGeoArray[i].face(n));
                }
            }
            this.removeDuplicates(d);
        }
        return this;
    }

    public IMeshGeo removeDuplicates() {
        return this.removeDuplicates(IConfig.tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeshGeo removeDuplicates(double d) {
        int n;
        Object object;
        int n2;
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>(this.vertices);
        ArrayList<IVertex> arrayList2 = new ArrayList<IVertex>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (n2 = 0; n2 < arrayList.size() - 1; ++n2) {
            object = arrayList.get(n2);
            for (int i = n2 + 1; i < arrayList.size(); ++i) {
                IVertex iVertex = arrayList.get(i);
                if (!((IVertex)object).eq(iVertex, d)) continue;
                arrayList.remove(i);
                --i;
                arrayList2.add(iVertex);
                arrayList3.add(object);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            arrayList.get((int)n2).edges.clear();
            arrayList.get((int)n2).faces.clear();
            arrayList.get((int)n2).linkedVertices.clear();
        }
        ArrayList<IEdge> arrayList4 = new ArrayList<IEdge>(this.edges);
        object = new ArrayList();
        ArrayList<IEdge> arrayList5 = new ArrayList<IEdge>();
        for (n = 0; n < arrayList4.size() - 1; ++n) {
            IEdge iEdge = arrayList4.get(n);
            for (int i = n + 1; i < arrayList4.size(); ++i) {
                IEdge iEdge2 = arrayList4.get(i);
                if (!iEdge.eq(iEdge2, d)) continue;
                arrayList4.remove(i);
                --i;
                ((ArrayList)object).add(iEdge2);
                arrayList5.add(iEdge);
            }
        }
        if (arrayList2.size() == 0 && ((ArrayList)object).size() == 0) {
            return this;
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            if (arrayList2.contains(arrayList4.get((int)n).vertices[0])) {
                arrayList4.get((int)n).vertices[0] = (IVertex)arrayList3.get(arrayList2.indexOf(arrayList4.get((int)n).vertices[0]));
            }
            if (arrayList2.contains(arrayList4.get((int)n).vertices[1])) {
                arrayList4.get((int)n).vertices[1] = (IVertex)arrayList3.get(arrayList2.indexOf(arrayList4.get((int)n).vertices[1]));
            }
            arrayList4.get((int)n).faces.clear();
            arrayList4.get((int)n).vertices[0].addEdge(arrayList4.get(n));
            arrayList4.get((int)n).vertices[1].addEdge(arrayList4.get(n));
        }
        ArrayList<IFace> arrayList6 = new ArrayList<IFace>();
        for (int i = 0; i < this.faces.size(); ++i) {
            IEdge[] iEdgeArray = new IEdge[this.faces.get(i).edgeNum()];
            for (int j = 0; j < this.faces.get(i).edgeNum(); ++j) {
                iEdgeArray[j] = ((ArrayList)object).contains(this.faces.get((int)i).edges[j]) ? (IEdge)arrayList5.get(((ArrayList)object).indexOf(this.faces.get((int)i).edges[j])) : this.faces.get((int)i).edges[j];
            }
            arrayList6.add(new IFace(iEdgeArray));
        }
        Object object2 = IG.lock;
        synchronized (object2) {
            this.vertices.clear();
            this.edges.clear();
            this.faces = arrayList6;
            for (int i = 0; i < arrayList6.size(); ++i) {
                int n3;
                IFace iFace = (IFace)arrayList6.get(i);
                for (n3 = 0; n3 < iFace.vertices.length; ++n3) {
                    if (this.vertices.contains(iFace.vertices[n3])) continue;
                    this.addVertex(iFace.vertices[n3]);
                }
                for (n3 = 0; n3 < iFace.edges.length; ++n3) {
                    if (this.edges.contains(iFace.edges[n3])) continue;
                    this.edges.add(iFace.edges[n3]);
                }
            }
        }
        return this;
    }

    public IMeshGeo loopSubD() {
        return this.loopSubdivide();
    }

    public IMeshGeo loopSubdivide() {
        return this.loopSubdivide(null);
    }

    public IMeshGeo loopSubD(IVec[] iVecArray) {
        return this.loopSubdivide(iVecArray);
    }

    public IMeshGeo loopSubdivide(IVec[] iVecArray) {
        int n;
        int n2;
        IVertex[] iVertexArray = new IVertex[this.vertexNum()];
        IVertex[] iVertexArray2 = new IVertex[this.edgeNum()];
        for (int i = 0; i < this.vertexNum(); ++i) {
            iVertexArray[i] = new IVertex(this.vertex(i).pos());
        }
        IEdge[] iEdgeArray = new IEdge[this.edgeNum() * 2];
        for (int i = 0; i < this.edgeNum(); ++i) {
            int n3 = this.vertexIndex(this.edge(i).vertex(0));
            n2 = this.vertexIndex(this.edge(i).vertex(1));
            iVertexArray2[i] = new IVertex(this.edge(i).vertex(0).pos().mid(this.edge(i).vertex(1).pos()));
            iEdgeArray[i * 2] = new IEdge(iVertexArray[n3], iVertexArray2[i]);
            iEdgeArray[i * 2 + 1] = new IEdge(iVertexArray2[i], iVertexArray[n2]);
        }
        IFace[] iFaceArray = new IFace[this.faceNum() * 4];
        IEdge[] iEdgeArray2 = new IEdge[this.faceNum() * 3];
        for (n2 = 0; n2 < this.faceNum(); ++n2) {
            IFace iFace = this.face(n2);
            int n4 = this.edgeIndex(iFace.edge(0));
            int n5 = this.edgeIndex(iFace.edge(1));
            int n6 = this.edgeIndex(iFace.edge(2));
            IEdge[] iEdgeArray3 = new IEdge[]{iEdgeArray[n4 * 2], iEdgeArray[n4 * 2 + 1], iEdgeArray[n5 * 2], iEdgeArray[n5 * 2 + 1], iEdgeArray[n6 * 2], iEdgeArray[n6 * 2 + 1]};
            IVertex iVertex = iVertexArray2[n4];
            IVertex iVertex2 = iVertexArray2[n5];
            IVertex iVertex3 = iVertexArray2[n6];
            IEdge iEdge = new IEdge(iVertex, iVertex2);
            IEdge iEdge2 = new IEdge(iVertex2, iVertex3);
            IEdge iEdge3 = new IEdge(iVertex3, iVertex);
            iEdgeArray2[n2 * 3] = iEdge;
            iEdgeArray2[n2 * 3 + 1] = iEdge2;
            iEdgeArray2[n2 * 3 + 2] = iEdge3;
            IEdge[] iEdgeArray4 = this.faceEdges(iEdge, iEdgeArray3);
            IEdge[] iEdgeArray5 = this.faceEdges(iEdge2, iEdgeArray3);
            IEdge[] iEdgeArray6 = this.faceEdges(iEdge3, iEdgeArray3);
            IEdge[] iEdgeArray7 = new IEdge[]{iEdge, iEdge2, iEdge3};
            iFaceArray[n2 * 4] = new IFace(iEdgeArray4);
            iFaceArray[n2 * 4 + 1] = new IFace(iEdgeArray5);
            iFaceArray[n2 * 4 + 2] = new IFace(iEdgeArray6);
            iFaceArray[n2 * 4 + 3] = new IFace(iEdgeArray7);
        }
        for (n2 = 0; n2 < iVertexArray2.length; ++n2) {
            boolean bl = false;
            if (iVecArray != null) {
                for (int i = 0; i < iVecArray.length / 2 && !bl; ++i) {
                    if (!iVertexArray2[n2].get().isOnSegment(iVecArray[i * 2], iVecArray[i * 2 + 1])) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            IVertex iVertex = this.edge(n2).face(0).getOtherVertex(this.edge(n2));
            IVertex iVertex4 = this.edge(n2).face(1).getOtherVertex(this.edge(n2));
            IVec iVec = new IVec();
            iVec.add(this.edge(n2).vertex(0).pos(), 0.375);
            iVec.add(this.edge(n2).vertex(1).pos(), 0.375);
            iVec.add(iVertex.pos(), 0.125);
            iVec.add(iVertex4.pos(), 0.125);
            iVertexArray2[n2].set(iVec);
        }
        for (n2 = 0; n2 < iVertexArray.length; ++n2) {
            boolean bl = false;
            if (iVecArray != null) {
                for (int i = 0; i < iVecArray.length / 2 && !bl; ++i) {
                    if (!this.vertex(n2).get().isOnSegment(iVecArray[i * 2], iVecArray[i * 2 + 1])) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            IVec iVec = new IVec();
            for (int i = 0; i < this.vertex((int)n2).linkedVertices.size(); ++i) {
                iVec.add(this.vertex((int)n2).linkedVertices.get(i).pos());
            }
            double d = 0.375 / (double)this.vertex((int)n2).linkedVertices.size();
            if (this.vertex((int)n2).linkedVertices.size() == 3) {
                d = 0.1875;
            }
            iVec.mul(d);
            iVec.add(iVertexArray[n2].pos(), 1.0 - d * (double)this.vertex((int)n2).linkedVertices.size());
            iVertexArray[n2].set(iVec);
        }
        IVertex[] iVertexArray3 = new IVertex[iVertexArray.length + iVertexArray2.length];
        IEdge[] iEdgeArray8 = new IEdge[iEdgeArray.length + iEdgeArray2.length];
        for (n = 0; n < iVertexArray.length; ++n) {
            iVertexArray3[n] = iVertexArray[n];
        }
        for (n = 0; n < iVertexArray2.length; ++n) {
            iVertexArray3[n + iVertexArray.length] = iVertexArray2[n];
        }
        for (n = 0; n < iEdgeArray.length; ++n) {
            iEdgeArray8[n] = iEdgeArray[n];
        }
        for (n = 0; n < iEdgeArray2.length; ++n) {
            iEdgeArray8[n + iEdgeArray.length] = iEdgeArray2[n];
        }
        return new IMeshGeo(iVertexArray3, iEdgeArray8, iFaceArray);
    }

    public IEdge[] faceEdges(IEdge iEdge, IEdge[] iEdgeArray) {
        boolean bl = false;
        for (int i = 0; i < iEdgeArray.length; ++i) {
            for (int j = 0; j < iEdgeArray.length; ++j) {
                if (i == j || !iEdgeArray[i].contains(iEdge.vertex(0)) || !iEdgeArray[j].contains(iEdge.vertex(1)) || iEdgeArray[i].getOtherVertex(iEdge.vertex(0)) != iEdgeArray[j].getOtherVertex(iEdge.vertex(1))) continue;
                return new IEdge[]{iEdgeArray[j], iEdge, iEdgeArray[i]};
            }
        }
        IG.p("no edge found");
        return null;
    }

    public int edgeIndex(IEdge iEdge) {
        for (int i = 0; i < this.edgeNum(); ++i) {
            if (this.edge(i) != iEdge) continue;
            return i;
        }
        return -1;
    }

    public int vertexIndex(IVertex iVertex) {
        for (int i = 0; i < this.vertexNum(); ++i) {
            if (this.vertex(i) != iVertex) continue;
            return i;
        }
        return -1;
    }

    public IMeshGeo offset(double[] dArray) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            IVec iVec;
            double d = 0.0;
            d = dArray.length < i ? dArray[i] : dArray[dArray.length - 1];
            if (d == 0.0 || !((iVec = this.vertices.get(i).nml().get().cp()).len2() > 0.0)) continue;
            this.vertices.get(i).add(iVec.len(d));
        }
        return this;
    }

    public IMeshGeo offset(double d) {
        if (d != 0.0) {
            for (int i = 0; i < this.vertices.size(); ++i) {
                IVec iVec = this.vertices.get(i).nml().get().cp();
                if (!(iVec.len2() > 0.0)) continue;
                this.vertices.get(i).add(iVec.len(d));
            }
        }
        return this;
    }

    public IMeshGeo flipNormal() {
        this.flipNml();
        return this;
    }

    public IMeshGeo flipNml() {
        int n;
        for (n = 0; n < this.faces.size(); ++n) {
            this.faces.get(n).flipNml();
        }
        for (n = 0; n < this.vertices.size(); ++n) {
            this.vertices.get(n).calcNormal();
        }
        return this;
    }

    public IMeshGeo unifyNormal() {
        this.unifyNml();
        return this;
    }

    public IMeshGeo unifyNml() {
        return this.unifyNml(0);
    }

    public IMeshGeo unifyNml(int n) {
        boolean[] blArray = new boolean[this.faces.size()];
        IFace iFace = this.faces.get(n);
        blArray[n] = true;
        for (int i = 0; i < this.faces.size(); ++i) {
            if (iFace == null) {
                IG.err("face iteration failed. no face found");
                return this;
            }
            IFace iFace2 = this.iterateFace(iFace, blArray);
            if (iFace2 != null) {
                if (iFace.sharedVertexOrder(iFace2) == 0) {
                    iFace2.flipNml();
                }
            } else {
                for (int j = 0; j < this.faces.size() && iFace2 == null; ++j) {
                    if (blArray[j]) continue;
                    iFace2 = this.faces.get(j);
                    blArray[j] = true;
                }
            }
            iFace = iFace2;
        }
        return this;
    }

    public IFace iterateFace(IFace iFace, boolean[] blArray) {
        for (int i = 0; i < iFace.edges.length; ++i) {
            IFace iFace2 = iFace.edges[i].getOtherFace(iFace);
            if (iFace2 == null) continue;
            int n = this.faces.indexOf(iFace2);
            if (n < 0) {
                IG.err("other face is not contained in mesh");
                return null;
            }
            if (blArray[n]) continue;
            IG.p("index = " + n);
            blArray[n] = true;
            return iFace2;
        }
        return null;
    }

    @Override
    public IMeshGeo add(double d, double d2, double d3) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).add(d, d2, d3);
        }
        return this;
    }

    @Override
    public IMeshGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).add(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public IMeshGeo add(IVecI iVecI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).add(iVecI);
        }
        return this;
    }

    @Override
    public IMeshGeo sub(double d, double d2, double d3) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).sub(d, d2, d3);
        }
        return this;
    }

    @Override
    public IMeshGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).sub(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public IMeshGeo sub(IVecI iVecI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).sub(iVecI);
        }
        return this;
    }

    @Override
    public IMeshGeo mul(IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).mul(iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo mul(double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).mul(d);
        }
        return this;
    }

    @Override
    public IMeshGeo div(IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).div(iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo div(double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).div(d);
        }
        return this;
    }

    @Override
    public IMeshGeo neg() {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).neg();
        }
        return this;
    }

    public IMeshGeo rev() {
        return this.neg();
    }

    @Override
    public IMeshGeo flip() {
        return this.neg();
    }

    @Override
    public IMeshGeo add(IVecI iVecI, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).add(iVecI, d);
        }
        return this;
    }

    @Override
    public IMeshGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).add(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IMeshGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public IMeshGeo rot(IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(d);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(IVecI iVecI, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iVecI, d);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iVecI, iVecI2, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iVecI, iVecI2, d);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IMeshGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot(iVecI, iVecI2, iVecI3);
        }
        return this;
    }

    @Override
    public IMeshGeo rot2(IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot2(iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo rot2(double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot2(d);
        }
        return this;
    }

    @Override
    public IMeshGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot2(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo rot2(IVecI iVecI, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot2(iVecI, d);
        }
        return this;
    }

    @Override
    public IMeshGeo rot2(IVecI iVecI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot2(iVecI);
        }
        return this;
    }

    @Override
    public IMeshGeo rot2(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).rot2(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IMeshGeo scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public IMeshGeo scale(double d) {
        return this.mul(d);
    }

    @Override
    public IMeshGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).scale(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo scale(IVecI iVecI, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).scale(iVecI, d);
        }
        return this;
    }

    @Override
    public IMeshGeo scale1d(IVecI iVecI, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).scale1d(iVecI, d);
        }
        return this;
    }

    @Override
    public IMeshGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).scale1d(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).scale1d(iVecI, iVecI2, d);
        }
        return this;
    }

    @Override
    public IMeshGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).scale1d(iVecI, iVecI2, iDoubleI);
        }
        return this;
    }

    @Override
    public IMeshGeo ref(IVecI iVecI) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).ref(iVecI);
        }
        return this;
    }

    @Override
    public IMeshGeo ref(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).ref(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IMeshGeo mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public IMeshGeo mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public IMeshGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shear(d, d2, d3, d4, d5, d6);
        }
        return this;
    }

    @Override
    public IMeshGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        }
        return this;
    }

    @Override
    public IMeshGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shear(iVecI, d, d2, d3, d4, d5, d6);
        }
        return this;
    }

    @Override
    public IMeshGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        }
        return this;
    }

    @Override
    public IMeshGeo shearXY(double d, double d2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearXY(d, d2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearXY(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearXY(IVecI iVecI, double d, double d2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearXY(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearXY(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearYZ(double d, double d2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearYZ(d, d2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearYZ(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearYZ(IVecI iVecI, double d, double d2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearYZ(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearYZ(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearZX(double d, double d2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearZX(d, d2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearZX(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearZX(IVecI iVecI, double d, double d2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearZX(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public IMeshGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).shearZX(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IMeshGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IMeshGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IMeshGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IMeshGeo cp() {
        return this.dup();
    }

    @Override
    public IMeshGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IMeshGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IMeshGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IMeshGeo translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IMeshGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IMeshGeo translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IMeshGeo transform(IMatrix3I iMatrix3I) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).transform(iMatrix3I);
        }
        return this;
    }

    @Override
    public IMeshGeo transform(IMatrix4I iMatrix4I) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).transform(iMatrix4I);
        }
        return this;
    }

    @Override
    public IMeshGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).transform(iVecI, iVecI2, iVecI3);
        }
        return this;
    }

    @Override
    public IMeshGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).transform(iVecI, iVecI2, iVecI3, iVecI4);
        }
        return this;
    }
}

