/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ISurfaceGeo;
import igeo.IVec;
import igeo.IVec2;

public class ISurfaceCache {
    public ISurfaceGeo surface;
    public int uresolution;
    public int vresolution;
    public int udeg;
    public int vdeg;
    public IVec[][] pts;
    public IVec2[][] pts2;

    public ISurfaceCache(ISurfaceGeo iSurfaceGeo, int n) {
        this.surface = iSurfaceGeo;
        this.uresolution = n;
        this.vresolution = n;
        this.udeg = iSurfaceGeo.udeg();
        this.vdeg = iSurfaceGeo.vdeg();
    }

    public ISurfaceCache(ISurfaceGeo iSurfaceGeo) {
        this(iSurfaceGeo, IConfig.surfaceCacheResolution);
    }

    public void init() {
        int n = (this.surface.uepNum() - 1) * this.uresolution + 1;
        int n2 = (this.surface.vepNum() - 1) * this.vresolution + 1;
        this.pts = new IVec[n][n2];
        int n3 = this.surface.uepNum();
        int n4 = this.surface.vepNum();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.uresolution; ++j) {
                if (i >= n3 - 1 && j != 0) continue;
                for (int k = 0; k < n4; ++k) {
                    for (int i2 = 0; i2 < this.vresolution; ++i2) {
                        if (k >= n4 - 1 && i2 != 0) continue;
                        this.pts[i * this.uresolution + j][k * this.vresolution + i2] = this.surface.pt(this.surface.u(i, (double)j / (double)this.uresolution), this.surface.v(k, (double)i2 / (double)this.vresolution));
                    }
                }
            }
        }
    }

    public void init2() {
        int n = (this.surface.uepNum() - 1) * this.uresolution + 1;
        int n2 = (this.surface.vepNum() - 1) * this.vresolution + 1;
        this.pts2 = new IVec2[n][n2];
        int n3 = this.surface.uepNum();
        int n4 = this.surface.vepNum();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < this.uresolution; ++j) {
                if (i >= n3 - 1 && j != 0) continue;
                for (int k = 0; k < n4; ++k) {
                    for (int i2 = 0; i2 < this.vresolution; ++i2) {
                        if (k >= n4 - 1 && i2 != 0) continue;
                        this.pts2[i * this.uresolution + j][k * this.vresolution + i2] = this.surface.pt(this.surface.u(i, (double)j / (double)this.uresolution), this.surface.v(k, (double)i2 / (double)this.vresolution)).to2d();
                    }
                }
            }
        }
    }

    public double u(int n) {
        return this.surface.u(n / this.uresolution, (double)(n % this.uresolution) / (double)this.uresolution);
    }

    public double v(int n) {
        return this.surface.v(n / this.vresolution, (double)(n % this.vresolution) / (double)this.vresolution);
    }

    public int[] getCloserTriangle(IVec iVec, int n, int n2) {
        double[][] dArray = new double[2][2];
        IVec iVec2 = this.pts[n][n2];
        IVec iVec3 = null;
        IVec iVec4 = null;
        IVec iVec5 = null;
        IVec iVec6 = null;
        if (n > 0) {
            iVec3 = this.pts[n - 1][n2];
        }
        if (n < this.pts.length - 1) {
            iVec4 = this.pts[n + 1][n2];
        }
        if (n2 > 0) {
            iVec5 = this.pts[n][n2 - 1];
        }
        if (n2 < this.pts[0].length - 1) {
            iVec6 = this.pts[n][n2 + 1];
        }
        double d = -1.0;
        int[] nArray = new int[2];
        if (iVec3 != null && iVec5 != null) {
            dArray[0][0] = iVec.distToTriangle(iVec2, iVec5, iVec3);
            d = dArray[0][0];
            nArray[0] = n - 1;
            nArray[1] = n2 - 1;
        }
        if (iVec4 != null && iVec5 != null) {
            dArray[1][0] = iVec.distToTriangle(iVec2, iVec4, iVec5);
            if (d < 0.0 || dArray[1][0] < d) {
                d = dArray[1][0];
                nArray[0] = n;
                nArray[1] = n2 - 1;
            }
        }
        if (iVec3 != null && iVec6 != null) {
            dArray[0][1] = iVec.distToTriangle(iVec2, iVec6, iVec3);
            if (d < 0.0 || dArray[0][1] < d) {
                d = dArray[0][1];
                nArray[0] = n - 1;
                nArray[1] = n2;
            }
        }
        if (iVec4 != null && iVec6 != null) {
            dArray[1][1] = iVec.distToTriangle(iVec2, iVec4, iVec6);
            if (d < 0.0 || dArray[1][1] < d) {
                d = dArray[1][1];
                nArray[0] = n;
                nArray[1] = n2;
            }
        }
        return nArray;
    }

    public int[] getCloserTriangle(IVec2 iVec2, int n, int n2) {
        double[][] dArray = new double[2][2];
        IVec2 iVec22 = this.pts2[n][n2];
        IVec2 iVec23 = null;
        IVec2 iVec24 = null;
        IVec2 iVec25 = null;
        IVec2 iVec26 = null;
        if (n > 0) {
            iVec23 = this.pts2[n - 1][n2];
        }
        if (n < this.pts2.length - 1) {
            iVec24 = this.pts2[n + 1][n2];
        }
        if (n2 > 0) {
            iVec25 = this.pts2[n][n2 - 1];
        }
        if (n2 < this.pts2[0].length - 1) {
            iVec26 = this.pts2[n][n2 + 1];
        }
        double d = -1.0;
        int[] nArray = new int[2];
        if (iVec23 != null && iVec25 != null) {
            dArray[0][0] = iVec2.distToTriangle(iVec22, iVec25, iVec23);
            d = dArray[0][0];
            nArray[0] = n - 1;
            nArray[1] = n2 - 1;
        }
        if (iVec24 != null && iVec25 != null) {
            dArray[1][0] = iVec2.distToTriangle(iVec22, iVec24, iVec25);
            if (d < 0.0 || dArray[1][0] < d) {
                d = dArray[1][0];
                nArray[0] = n;
                nArray[1] = n2 - 1;
            }
        }
        if (iVec23 != null && iVec26 != null) {
            dArray[0][1] = iVec2.distToTriangle(iVec22, iVec26, iVec23);
            if (d < 0.0 || dArray[0][1] < d) {
                d = dArray[0][1];
                nArray[0] = n - 1;
                nArray[1] = n2;
            }
        }
        if (iVec24 != null && iVec26 != null) {
            dArray[1][1] = iVec2.distToTriangle(iVec22, iVec24, iVec26);
            if (d < 0.0 || dArray[1][1] < d) {
                d = dArray[1][1];
                nArray[0] = n;
                nArray[1] = n2;
            }
        }
        return nArray;
    }

    public IVec2 uv(IVec iVec) {
        if (this.pts == null) {
            this.init();
        }
        int[] nArray = this.closest(iVec);
        int[] nArray2 = this.getCloserTriangle(iVec, nArray[0], nArray[1]);
        double d = this.u(nArray2[0]);
        double d2 = this.v(nArray2[1]);
        double d3 = this.u(nArray2[0] + 1);
        double d4 = this.v(nArray2[1] + 1);
        return this.recursiveSearch(iVec, d, d2, d3, d4, (IVec[][])null, 0);
    }

    public IVec2 uv(IVec2 iVec2) {
        if (this.pts2 == null) {
            this.init2();
        }
        int[] nArray = this.closest(iVec2);
        int[] nArray2 = this.getCloserTriangle(iVec2, nArray[0], nArray[1]);
        double d = this.u(nArray2[0]);
        double d2 = this.v(nArray2[1]);
        double d3 = this.u(nArray2[0] + 1);
        double d4 = this.v(nArray2[1] + 1);
        return this.recursiveSearch(iVec2, d, d2, d3, d4, (IVec2[][])null, 0);
    }

    public IVec2 recursiveSearch(IVec iVec, double d, double d2, double d3, double d4, IVec[][] iVecArray, int n) {
        int n2;
        double d5 = (3.0 * d + d3) / 4.0;
        double d6 = (d + 3.0 * d3) / 4.0;
        double d7 = (3.0 * d2 + d4) / 4.0;
        double d8 = (d2 + 3.0 * d4) / 4.0;
        IVec[][] iVecArray2 = new IVec[2][2];
        iVecArray2[0][0] = this.surface.pt(d5, d7);
        iVecArray2[1][0] = this.surface.pt(d6, d7);
        iVecArray2[0][1] = this.surface.pt(d5, d8);
        iVecArray2[1][1] = this.surface.pt(d6, d8);
        double d9 = 0.0;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = 0; i < 2; ++i) {
                double d10 = iVecArray2[n2][i].dist(iVec);
                if ((n2 != 0 || i != 0) && !(d10 < d9)) continue;
                d9 = d10;
                n3 = n2;
                n4 = i;
            }
        }
        n2 = iVecArray2[0][0].dist(iVecArray2[1][1]) < IConfig.tolerance && iVecArray2[1][0].dist(iVecArray2[0][1]) < IConfig.tolerance ? 1 : 0;
        double d11 = (d + d3) / 2.0;
        double d12 = (d2 + d4) / 2.0;
        ++n;
        if (n3 == 0) {
            if (n4 == 0) {
                if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
                    return new IVec2(d, d2);
                }
                return this.recursiveSearch(iVec, d, d2, d11, d12, (IVec[][])null, n);
            }
            if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
                return new IVec2(d, d4);
            }
            return this.recursiveSearch(iVec, d, d12, d11, d4, (IVec[][])null, n);
        }
        if (n4 == 0) {
            if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
                return new IVec2(d3, d2);
            }
            return this.recursiveSearch(iVec, d11, d2, d3, d12, (IVec[][])null, n);
        }
        if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
            return new IVec2(d3, d4);
        }
        return this.recursiveSearch(iVec, d11, d12, d3, d4, (IVec[][])null, n);
    }

    public IVec2 recursiveSearch(IVec2 iVec2, double d, double d2, double d3, double d4, IVec2[][] iVec2Array, int n) {
        int n2;
        double d5 = (3.0 * d + d3) / 4.0;
        double d6 = (d + 3.0 * d3) / 4.0;
        double d7 = (3.0 * d2 + d4) / 4.0;
        double d8 = (d2 + 3.0 * d4) / 4.0;
        IVec2[][] iVec2Array2 = new IVec2[2][2];
        iVec2Array2[0][0] = this.surface.pt(d5, d7).to2d();
        iVec2Array2[1][0] = this.surface.pt(d6, d7).to2d();
        iVec2Array2[0][1] = this.surface.pt(d5, d8).to2d();
        iVec2Array2[1][1] = this.surface.pt(d6, d8).to2d();
        double d9 = 0.0;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = 0; i < 2; ++i) {
                double d10 = iVec2Array2[n2][i].dist(iVec2);
                if ((n2 != 0 || i != 0) && !(d10 < d9)) continue;
                d9 = d10;
                n3 = n2;
                n4 = i;
            }
        }
        n2 = iVec2Array2[0][0].dist(iVec2Array2[1][1]) < IConfig.tolerance && iVec2Array2[1][0].dist(iVec2Array2[0][1]) < IConfig.tolerance ? 1 : 0;
        double d11 = (d + d3) / 2.0;
        double d12 = (d2 + d4) / 2.0;
        ++n;
        if (n3 == 0) {
            if (n4 == 0) {
                if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
                    return new IVec2(d, d2);
                }
                return this.recursiveSearch(iVec2, d, d2, d11, d12, (IVec2[][])null, n);
            }
            if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
                return new IVec2(d, d4);
            }
            return this.recursiveSearch(iVec2, d, d12, d11, d4, (IVec2[][])null, n);
        }
        if (n4 == 0) {
            if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
                return new IVec2(d3, d2);
            }
            return this.recursiveSearch(iVec2, d11, d2, d3, d12, (IVec2[][])null, n);
        }
        if (d9 < IConfig.tolerance || n2 != 0 || n >= IConfig.cacheRecursionMaxDepth) {
            return new IVec2(d3, d4);
        }
        return this.recursiveSearch(iVec2, d11, d12, d3, d4, (IVec2[][])null, n);
    }

    public int[] closest(IVec iVec) {
        int n = -1;
        int n2 = -1;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.pts.length; ++i) {
            for (int j = 0; j < this.pts[i].length; ++j) {
                d = iVec.dist(this.pts[i][j]);
                if ((i != 0 || j != 0) && !(d < d2)) continue;
                d2 = d;
                n = i;
                n2 = j;
            }
        }
        return new int[]{n, n2};
    }

    public int[] closest(IVec2 iVec2) {
        int n = -1;
        int n2 = -1;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.pts2.length; ++i) {
            for (int j = 0; j < this.pts2[i].length; ++j) {
                d = iVec2.dist(this.pts2[i][j]);
                if ((i != 0 || j != 0) && !(d < d2)) continue;
                d2 = d;
                n = i;
                n2 = j;
            }
        }
        return new int[]{n, n2};
    }
}

